/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;

public class RabbitMQDeclareSupport {
    private final RabbitMQEndpoint endpoint;

    RabbitMQDeclareSupport(RabbitMQEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void declareAndBindExchangesAndQueuesUsing(Channel channel) throws IOException {
        this.declareAndBindDeadLetterExchangeWithQueue(channel);
        this.declareAndBindExchangeWithQueue(channel);
    }

    private void declareAndBindDeadLetterExchangeWithQueue(Channel channel) throws IOException {
        if (this.endpoint.getDeadLetterExchange() != null) {
            this.declareExchange(channel, this.endpoint.getDeadLetterExchange(), this.endpoint.getDeadLetterExchangeType(), Collections.emptyMap());
            this.declareAndBindQueue(channel, this.endpoint.getDeadLetterQueue(), this.endpoint.getDeadLetterExchange(), this.endpoint.getDeadLetterRoutingKey(), null);
        }
    }

    private void declareAndBindExchangeWithQueue(Channel channel) throws IOException {
        if (this.shouldDeclareExchange()) {
            this.declareExchange(channel, this.endpoint.getExchangeName(), this.endpoint.getExchangeType(), this.resolvedExchangeArguments());
        }
        if (this.shouldDeclareQueue()) {
            this.declareAndBindQueue(channel, this.endpoint.getQueue(), this.endpoint.getExchangeName(), this.endpoint.getRoutingKey(), this.resolvedQueueArguments());
        }
    }

    private Map<String, Object> resolvedQueueArguments() {
        HashMap<String, Object> queueArgs = new HashMap<String, Object>();
        this.populateQueueArgumentsFromDeadLetterExchange(queueArgs);
        this.populateQueueArgumentsFromConfigurer(queueArgs);
        return queueArgs;
    }

    private Map<String, Object> populateQueueArgumentsFromDeadLetterExchange(Map<String, Object> queueArgs) {
        if (this.endpoint.getDeadLetterExchange() != null) {
            queueArgs.put("x-dead-letter-exchange", this.endpoint.getDeadLetterExchange());
            queueArgs.put("x-dead-letter-routing-key", this.endpoint.getDeadLetterRoutingKey());
        }
        return queueArgs;
    }

    private Map<String, Object> resolvedExchangeArguments() {
        HashMap<String, Object> exchangeArgs = new HashMap<String, Object>();
        if (this.endpoint.getExchangeArgsConfigurer() != null) {
            this.endpoint.getExchangeArgsConfigurer().configurArgs(exchangeArgs);
        }
        return exchangeArgs;
    }

    private boolean shouldDeclareQueue() {
        return !this.endpoint.isSkipQueueDeclare() && this.endpoint.getQueue() != null;
    }

    private boolean shouldDeclareExchange() {
        return !this.endpoint.isSkipExchangeDeclare();
    }

    private void populateQueueArgumentsFromConfigurer(Map<String, Object> queueArgs) {
        if (this.endpoint.getQueueArgsConfigurer() != null) {
            this.endpoint.getQueueArgsConfigurer().configurArgs(queueArgs);
        }
    }

    private void declareExchange(Channel channel, String exchange, String exchangeType, Map<String, Object> exchangeArgs) throws IOException {
        channel.exchangeDeclare(exchange, exchangeType, this.endpoint.isDurable(), this.endpoint.isAutoDelete(), exchangeArgs);
    }

    private void declareAndBindQueue(Channel channel, String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        channel.queueDeclare(queue, this.endpoint.isDurable(), false, this.endpoint.isAutoDelete(), arguments);
        channel.queueBind(queue, exchange, this.emptyIfNull(routingKey));
    }

    private String emptyIfNull(String routingKey) {
        return routingKey == null ? "" : routingKey;
    }
}

