/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.etcd.AbstractEtcdEndpoint;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdKeysEndpoint;
import org.apache.camel.component.etcd.EtcdNamespace;
import org.apache.camel.component.etcd.EtcdStatsEndpoint;
import org.apache.camel.component.etcd.EtcdWatchEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ObjectHelper;

public class EtcdComponent
extends UriEndpointComponent {
    public EtcdComponent() {
        super(AbstractEtcdEndpoint.class);
    }

    public EtcdComponent(CamelContext context) {
        super(context, AbstractEtcdEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String ns = ObjectHelper.before((String)remaining, (String)"/");
        String path = ObjectHelper.after((String)remaining, (String)"/");
        if (ns == null) {
            ns = remaining;
        }
        if (path == null) {
            path = remaining;
        }
        EtcdNamespace namespace = (EtcdNamespace)((Object)this.getCamelContext().getTypeConverter().mandatoryConvertTo(EtcdNamespace.class, (Object)ns));
        EtcdConfiguration configuration = this.loadConfiguration(new EtcdConfiguration(), parameters);
        if (namespace != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            switch (namespace) {
                case stats: {
                    return new EtcdStatsEndpoint(uri, this, configuration, namespace, path);
                }
                case watch: {
                    return new EtcdWatchEndpoint(uri, this, configuration, namespace, path);
                }
                case keys: {
                    return new EtcdKeysEndpoint(uri, this, configuration, namespace, path);
                }
            }
            throw new IllegalStateException("No endpoint for " + remaining);
        }
        throw new IllegalStateException("No endpoint for " + remaining);
    }

    protected <T> T loadConfiguration(T configuration, Map<String, Object> parameters) throws Exception {
        this.setProperties(configuration, parameters);
        return configuration;
    }
}

