/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import java.net.URI;
import javax.net.ssl.SSLContext;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.EtcdSecurityContext;
import org.apache.camel.Component;
import org.apache.camel.component.etcd.AbstractEtcdConsumer;
import org.apache.camel.component.etcd.EtcdComponent;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdNamespace;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="etcd", title="etcd", syntax="etcd:namespace/path", consumerClass=AbstractEtcdConsumer.class, label="etcd")
public abstract class AbstractEtcdEndpoint
extends DefaultEndpoint {
    @UriPath(description="The API namespace to use", enums="keys,stats,watch")
    @Metadata(required="true")
    private final EtcdNamespace namespace;
    @UriPath(description="The path the enpoint refers to")
    @Metadata(required="false")
    private final String path;
    @UriParam
    private final EtcdConfiguration configuration;

    protected AbstractEtcdEndpoint(String uri, EtcdComponent component, EtcdConfiguration configuration, EtcdNamespace namespace, String path) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.namespace = namespace;
        this.path = path;
    }

    public boolean isSingleton() {
        return true;
    }

    public EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    public EtcdNamespace getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }

    public EtcdClient createClient() throws Exception {
        String[] uris = this.configuration.getUris() != null ? this.configuration.getUris().split(",") : "http://localhost:2379,http://localhost:4001".split(",");
        URI[] etcdUriList = new URI[uris.length];
        int i = 0;
        for (String uri : uris) {
            etcdUriList[i++] = URI.create(this.getCamelContext().resolvePropertyPlaceholders(uri));
        }
        return new EtcdClient(new EtcdSecurityContext(this.createSslContext(this.configuration), this.configuration.getUserName(), this.configuration.getPassword()), etcdUriList);
    }

    private SSLContext createSslContext(EtcdConfiguration configuration) throws Exception {
        if (configuration.getSslContextParameters() != null) {
            return configuration.getSslContextParameters().createSSLContext();
        }
        return null;
    }
}

