/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.batch;

import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionCompletion
implements Synchronization {
    private static final Logger LOG = LoggerFactory.getLogger(SessionCompletion.class);
    private final Session session;

    public SessionCompletion(Session session) {
        this.session = session;
    }

    public void onComplete(Exchange exchange) {
        try {
            LOG.debug("Committing");
            this.session.commit();
        }
        catch (JMSException ex) {
            LOG.warn("Exception caught while committing JMS session", (Throwable)ex);
        }
    }

    public void onFailure(Exchange exchange) {
        try {
            LOG.debug("Rolling back");
            this.session.rollback();
        }
        catch (JMSException ex) {
            LOG.warn("Exception caught while rolling back JMS session", (Throwable)ex);
        }
    }
}

