/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.component.mllp.MllpComponent;

public class MllpException
extends Exception {
    private final byte[] hl7Message;
    private final byte[] hl7Acknowledgement;

    public MllpException(String message) {
        super(message);
        this.hl7Message = null;
        this.hl7Acknowledgement = null;
    }

    public MllpException(String message, byte[] hl7Message) {
        super(message);
        this.hl7Message = hl7Message != null && hl7Message.length > 0 ? hl7Message : null;
        this.hl7Acknowledgement = null;
    }

    public MllpException(String message, byte[] hl7Message, byte[] hl7Acknowledgement) {
        super(message);
        this.hl7Message = hl7Message != null && hl7Message.length > 0 ? hl7Message : null;
        this.hl7Acknowledgement = hl7Acknowledgement != null && hl7Acknowledgement.length > 0 ? hl7Acknowledgement : null;
    }

    public MllpException(String message, Throwable cause) {
        super(message, cause);
        this.hl7Message = null;
        this.hl7Acknowledgement = null;
    }

    public MllpException(String message, byte[] hl7Message, Throwable cause) {
        super(message, cause);
        this.hl7Message = hl7Message != null && hl7Message.length > 0 ? hl7Message : null;
        this.hl7Acknowledgement = null;
    }

    public MllpException(String message, byte[] hl7Message, byte[] hl7Acknowledgement, Throwable cause) {
        super(message, cause);
        this.hl7Message = hl7Message != null && hl7Message.length > 0 ? hl7Message : null;
        this.hl7Acknowledgement = hl7Acknowledgement != null && hl7Acknowledgement.length > 0 ? hl7Acknowledgement : null;
    }

    public byte[] getHl7Message() {
        return this.hl7Message;
    }

    public byte[] getHl7Acknowledgement() {
        return this.hl7Acknowledgement;
    }

    @Override
    public String getMessage() {
        if (MllpComponent.isLogPhi()) {
            return String.format("%s \n\t{hl7Message= %s} \n\t{hl7Acknowledgement= %s}", super.getMessage(), MllpComponent.covertBytesToPrintFriendlyString(this.hl7Message), MllpComponent.covertBytesToPrintFriendlyString(this.hl7Acknowledgement));
        }
        return super.getMessage();
    }

    public byte[] getMllpPayload() {
        return this.hl7Acknowledgement != null && this.hl7Acknowledgement.length > 0 ? this.hl7Acknowledgement : this.hl7Message;
    }
}

