/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snakeyaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.camel.component.snakeyaml.TypeFilter;
import org.apache.camel.util.ObjectHelper;

public final class TypeFilters {
    private TypeFilters() {
    }

    public static TypeFilter valueOf(String definition) {
        String val;
        String type = ObjectHelper.before((String)definition, (String)":");
        if (type == null || "type".equals(type)) {
            String val2 = ObjectHelper.after((String)definition, (String)":");
            if (val2 != null) {
                return new TypeName(val2);
            }
        } else if ("regexp".equals(type) && (val = ObjectHelper.after((String)definition, (String)":")) != null) {
            return new RegExp(val);
        }
        return null;
    }

    public static TypeFilter regexp(String ... patterns) {
        return new RegExp(Arrays.asList(patterns));
    }

    public static TypeFilter regexp(Collection<String> patterns) {
        return new RegExp(patterns);
    }

    public static TypeFilter typeNames(Collection<String> types) {
        return new TypeName(types);
    }

    public static TypeFilter typeNames(String ... types) {
        return TypeFilters.typeNames(Arrays.asList(types));
    }

    public static TypeFilter types(Collection<Class<?>> types) {
        ArrayList<String> filters = new ArrayList<String>(types.size());
        for (Class<?> type : types) {
            filters.add(type.getName());
        }
        return new TypeName(filters);
    }

    public static TypeFilter types(Class<?> ... types) {
        return TypeFilters.types(Arrays.asList(types));
    }

    public static TypeFilter allowAll() {
        return new TypeFilter(){

            @Override
            public boolean test(String type) {
                return true;
            }
        };
    }

    public static TypeFilter allowNone() {
        return new TypeFilter(){

            @Override
            public boolean test(String type) {
                return false;
            }
        };
    }

    public static final class TypeName
    implements TypeFilter {
        private final List<String> values;

        public TypeName(String value) {
            this.values = Collections.singletonList(value);
        }

        public TypeName(Collection<String> values) {
            this.values = new ArrayList<String>(values);
        }

        @Override
        public boolean test(String type) {
            return this.values.contains(type);
        }
    }

    public static final class RegExp
    implements TypeFilter {
        private final List<Pattern> patterns;

        public RegExp(String pattern) {
            this.patterns = Collections.singletonList(Pattern.compile(pattern));
        }

        public RegExp(Collection<String> patterns) {
            this.patterns = new ArrayList<Pattern>(patterns.size());
            for (String pattern : patterns) {
                this.patterns.add(Pattern.compile(pattern));
            }
        }

        @Override
        public boolean test(String type) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(type).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

