/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook.config;

import facebook4j.Facebook;
import facebook4j.FacebookException;
import facebook4j.FacebookFactory;
import facebook4j.auth.Authorization;
import facebook4j.auth.OAuthAuthorization;
import facebook4j.conf.Configuration;
import facebook4j.conf.ConfigurationBuilder;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class FacebookConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(FacebookConfiguration.class);
    @UriParam(label="security")
    private String oAuthAppId;
    @UriParam(label="security")
    private String oAuthAppSecret;
    @UriParam(label="security")
    private String oAuthAccessToken;
    @UriParam(label="security", defaultValue="https://www.facebook.com/dialog/oauth")
    private String oAuthAuthorizationURL;
    @UriParam(label="security")
    private String oAuthPermissions;
    @UriParam(label="security", defaultValue="https://graph.facebook.com/oauth/access_token")
    private String oAuthAccessTokenURL;
    @UriParam
    private String clientURL;
    @UriParam
    private String clientVersion;
    @UriParam(defaultValue="false")
    private Boolean debugEnabled;
    @UriParam(defaultValue="true")
    private Boolean gzipEnabled;
    @UriParam(defaultValue="20000")
    private Integer httpConnectionTimeout;
    @UriParam(defaultValue="2")
    private Integer httpDefaultMaxPerRoute;
    @UriParam(defaultValue="20")
    private Integer httpMaxTotalConnections;
    @UriParam(label="proxy")
    private String httpProxyHost;
    @UriParam(label="proxy")
    private String httpProxyPassword;
    @UriParam(label="proxy")
    private Integer httpProxyPort;
    @UriParam(label="proxy")
    private String httpProxyUser;
    @UriParam(defaultValue="120000")
    private Integer httpReadTimeout;
    @UriParam(defaultValue="0")
    private Integer httpRetryCount;
    @UriParam(defaultValue="5")
    private Integer httpRetryIntervalSeconds;
    @UriParam(defaultValue="40000")
    private Integer httpStreamingReadTimeout;
    @UriParam(defaultValue="false")
    private Boolean jsonStoreEnabled;
    @UriParam(defaultValue="false")
    private Boolean mbeanEnabled;
    @UriParam(defaultValue="false")
    private Boolean prettyDebugEnabled;
    @UriParam(defaultValue="https://graph.facebook.com/")
    private String restBaseURL;
    @UriParam(defaultValue="true")
    private Boolean useSSL;
    @UriParam(defaultValue="https://graph-video.facebook.com/")
    private String videoBaseURL;
    private Facebook facebook;

    public Configuration getConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (this.oAuthAccessToken != null) {
            builder.setOAuthAccessToken(this.oAuthAccessToken);
        }
        if (this.oAuthAccessTokenURL != null) {
            builder.setOAuthAccessTokenURL(this.oAuthAccessTokenURL);
        }
        if (this.oAuthAppId != null) {
            builder.setOAuthAppId(this.oAuthAppId);
        }
        if (this.oAuthAppSecret != null) {
            builder.setOAuthAppSecret(this.oAuthAppSecret);
        }
        if (this.oAuthAuthorizationURL != null) {
            builder.setOAuthAuthorizationURL(this.oAuthAuthorizationURL);
        }
        if (this.oAuthPermissions != null) {
            builder.setOAuthPermissions(this.oAuthPermissions);
        }
        if (this.clientURL != null) {
            builder.setClientURL(this.clientURL);
        }
        if (this.clientVersion != null) {
            builder.setClientVersion(this.clientVersion);
        }
        if (this.debugEnabled != null) {
            builder.setDebugEnabled(this.debugEnabled.booleanValue());
        }
        if (this.gzipEnabled != null) {
            builder.setGZIPEnabled(this.gzipEnabled.booleanValue());
        }
        if (this.httpConnectionTimeout != null) {
            builder.setHttpConnectionTimeout(this.httpConnectionTimeout.intValue());
        }
        if (this.httpDefaultMaxPerRoute != null) {
            builder.setHttpDefaultMaxPerRoute(this.httpDefaultMaxPerRoute.intValue());
        }
        if (this.httpMaxTotalConnections != null) {
            builder.setHttpMaxTotalConnections(this.httpMaxTotalConnections.intValue());
        }
        if (this.httpProxyHost != null) {
            builder.setHttpProxyHost(this.httpProxyHost);
        }
        if (this.httpProxyPassword != null) {
            builder.setHttpProxyPassword(this.httpProxyPassword);
        }
        if (this.httpProxyPort != null) {
            builder.setHttpProxyPort(this.httpProxyPort.intValue());
        }
        if (this.httpProxyUser != null) {
            builder.setHttpProxyUser(this.httpProxyUser);
        }
        if (this.httpReadTimeout != null) {
            builder.setHttpReadTimeout(this.httpReadTimeout.intValue());
        }
        if (this.httpRetryCount != null) {
            builder.setHttpRetryCount(this.httpRetryCount.intValue());
        }
        if (this.httpRetryIntervalSeconds != null) {
            builder.setHttpRetryIntervalSeconds(this.httpRetryIntervalSeconds.intValue());
        }
        if (this.httpStreamingReadTimeout != null) {
            builder.setHttpStreamingReadTimeout(this.httpStreamingReadTimeout.intValue());
        }
        if (this.jsonStoreEnabled != null) {
            builder.setJSONStoreEnabled(this.jsonStoreEnabled.booleanValue());
        }
        if (this.mbeanEnabled != null) {
            builder.setMBeanEnabled(this.mbeanEnabled.booleanValue());
        }
        if (this.prettyDebugEnabled != null) {
            builder.setPrettyDebugEnabled(this.prettyDebugEnabled.booleanValue());
        }
        if (this.restBaseURL != null) {
            builder.setRestBaseURL(this.restBaseURL);
        }
        if (this.useSSL != null) {
            builder.setUseSSL(this.useSSL.booleanValue());
        }
        if (this.videoBaseURL != null) {
            builder.setVideoBaseURL(this.videoBaseURL);
        }
        return builder.build();
    }

    public Facebook getFacebook() throws FacebookException {
        if (this.facebook == null) {
            Configuration configuration = this.getConfiguration();
            FacebookFactory factory = new FacebookFactory(configuration);
            if (this.oAuthAccessToken == null) {
                this.facebook = factory.getInstance((Authorization)new OAuthAuthorization(configuration));
                this.facebook.getOAuthAppAccessToken();
                LOG.warn("Login with app id and secret, access to some APIs is restricted!");
            } else {
                this.facebook = factory.getInstance();
                this.facebook.getOAuthAccessToken();
                LOG.debug("Login with app id, secret and token, all APIs accessible");
            }
        }
        return this.facebook;
    }

    public FacebookConfiguration copy() throws CloneNotSupportedException {
        FacebookConfiguration copy = (FacebookConfiguration)this.clone();
        copy.facebook = null;
        return copy;
    }

    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    public void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    public void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = oAuthAccessTokenURL;
    }

    public String getOAuthAppId() {
        return this.oAuthAppId;
    }

    public void setOAuthAppId(String oAuthAppId) {
        this.oAuthAppId = oAuthAppId;
    }

    public String getOAuthAppSecret() {
        return this.oAuthAppSecret;
    }

    public void setOAuthAppSecret(String oAuthAppSecret) {
        this.oAuthAppSecret = oAuthAppSecret;
    }

    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    public void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.oAuthAuthorizationURL = oAuthAuthorizationURL;
    }

    public String getClientURL() {
        return this.clientURL;
    }

    public void setClientURL(String clientURL) {
        this.clientURL = clientURL;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Boolean getDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(Boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public Boolean getGzipEnabled() {
        return this.gzipEnabled;
    }

    public void setGzipEnabled(Boolean gzipEnabled) {
        this.gzipEnabled = gzipEnabled;
    }

    public Integer getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public void setHttpConnectionTimeout(Integer httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    public Integer getHttpDefaultMaxPerRoute() {
        return this.httpDefaultMaxPerRoute;
    }

    public void setHttpDefaultMaxPerRoute(Integer httpDefaultMaxPerRoute) {
        this.httpDefaultMaxPerRoute = httpDefaultMaxPerRoute;
    }

    public Integer getHttpMaxTotalConnections() {
        return this.httpMaxTotalConnections;
    }

    public void setHttpMaxTotalConnections(Integer httpMaxTotalConnections) {
        this.httpMaxTotalConnections = httpMaxTotalConnections;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public void setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
    }

    public Integer getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpReadTimeout(Integer httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    public Integer getHttpRetryCount() {
        return this.httpRetryCount;
    }

    public void setHttpRetryCount(Integer httpRetryCount) {
        this.httpRetryCount = httpRetryCount;
    }

    public Integer getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    public void setHttpRetryIntervalSeconds(Integer httpRetryIntervalSeconds) {
        this.httpRetryIntervalSeconds = httpRetryIntervalSeconds;
    }

    public Integer getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    public void setHttpStreamingReadTimeout(Integer httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
    }

    public Boolean getJsonStoreEnabled() {
        return this.jsonStoreEnabled;
    }

    public void setJsonStoreEnabled(Boolean jsonStoreEnabled) {
        this.jsonStoreEnabled = jsonStoreEnabled;
    }

    public Boolean getMbeanEnabled() {
        return this.mbeanEnabled;
    }

    public void setMbeanEnabled(Boolean mbeanEnabled) {
        this.mbeanEnabled = mbeanEnabled;
    }

    public String getOAuthPermissions() {
        return this.oAuthPermissions;
    }

    public void setOAuthPermissions(String oAuthPermissions) {
        this.oAuthPermissions = oAuthPermissions;
    }

    public Boolean getPrettyDebugEnabled() {
        return this.prettyDebugEnabled;
    }

    public void setPrettyDebugEnabled(Boolean prettyDebugEnabled) {
        this.prettyDebugEnabled = prettyDebugEnabled;
    }

    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    public void setRestBaseURL(String restBaseURL) {
        this.restBaseURL = restBaseURL;
    }

    public Boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(Boolean useSSL) {
        this.useSSL = useSSL;
    }

    public String getVideoBaseURL() {
        return this.videoBaseURL;
    }

    public void setVideoBaseURL(String videoBaseURL) {
        this.videoBaseURL = videoBaseURL;
    }

    public void validate() {
        if (this.oAuthAppId == null || this.oAuthAppId.isEmpty() || this.oAuthAppSecret == null || this.oAuthAppSecret.isEmpty()) {
            throw new IllegalArgumentException("Missing required properties oAuthAppId, oAuthAppSecret");
        }
    }
}

