/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisClient;
import org.apache.camel.component.redis.RedisConfiguration;

class CommandDispatcher {
    private final RedisConfiguration configuration;

    CommandDispatcher(RedisConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(RedisClient redisClient, Exchange exchange) {
        Command command = this.determineCommand(exchange);
        switch (command) {
            case PING: {
                this.setResult(exchange, redisClient.ping());
                break;
            }
            case SET: {
                redisClient.set(this.getKey(exchange), this.getValue(exchange));
                break;
            }
            case GET: {
                this.setResult(exchange, redisClient.get(this.getKey(exchange)));
                break;
            }
            case QUIT: {
                redisClient.quit();
                break;
            }
            case EXISTS: {
                this.setResult(exchange, redisClient.exists(this.getKey(exchange)));
                break;
            }
            case DEL: {
                redisClient.del(this.getKeys(exchange));
                break;
            }
            case TYPE: {
                this.setResult(exchange, redisClient.type(this.getKey(exchange)));
                break;
            }
            case KEYS: {
                this.setResult(exchange, redisClient.keys(this.getPattern(exchange)));
                break;
            }
            case RANDOMKEY: {
                this.setResult(exchange, redisClient.randomkey());
                break;
            }
            case RENAME: {
                redisClient.rename(this.getKey(exchange), this.getStringValue(exchange));
                break;
            }
            case RENAMENX: {
                this.setResult(exchange, redisClient.renamenx(this.getKey(exchange), this.getStringValue(exchange)));
                break;
            }
            case EXPIRE: {
                this.setResult(exchange, redisClient.expire(this.getKey(exchange), this.getTimeout(exchange)));
                break;
            }
            case EXPIREAT: {
                this.setResult(exchange, redisClient.expireat(this.getKey(exchange), this.getTimestamp(exchange)));
                break;
            }
            case PEXPIRE: {
                this.setResult(exchange, redisClient.pexpire(this.getKey(exchange), this.getTimeout(exchange)));
                break;
            }
            case PEXPIREAT: {
                this.setResult(exchange, redisClient.pexpireat(this.getKey(exchange), this.getTimestamp(exchange)));
                break;
            }
            case TTL: {
                this.setResult(exchange, redisClient.ttl(this.getKey(exchange)));
                break;
            }
            case MOVE: {
                this.setResult(exchange, redisClient.move(this.getKey(exchange), this.getDb(exchange)));
                break;
            }
            case GETSET: {
                this.setResult(exchange, redisClient.getset(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case MGET: {
                this.setResult(exchange, redisClient.mget(this.getFields(exchange)));
                break;
            }
            case SETNX: {
                this.setResult(exchange, redisClient.setnx(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case SETEX: {
                redisClient.setex(this.getKey(exchange), this.getValue(exchange), this.getTimeout(exchange), TimeUnit.SECONDS);
                break;
            }
            case MSET: {
                redisClient.mset(this.getValuesAsMap(exchange));
                break;
            }
            case MSETNX: {
                redisClient.msetnx(this.getValuesAsMap(exchange));
                break;
            }
            case DECRBY: {
                this.setResult(exchange, redisClient.decrby(this.getKey(exchange), this.getLongValue(exchange)));
                break;
            }
            case DECR: {
                this.setResult(exchange, redisClient.decr(this.getKey(exchange)));
                break;
            }
            case INCRBY: {
                this.setResult(exchange, redisClient.incrby(this.getKey(exchange), this.getLongValue(exchange)));
                break;
            }
            case INCR: {
                this.setResult(exchange, redisClient.incr(this.getKey(exchange)));
                break;
            }
            case APPEND: {
                this.setResult(exchange, redisClient.append(this.getKey(exchange), this.getStringValue(exchange)));
                break;
            }
            case HSET: {
                redisClient.hset(this.getKey(exchange), this.getField(exchange), this.getValue(exchange));
                break;
            }
            case HGET: {
                this.setResult(exchange, redisClient.hget(this.getKey(exchange), this.getField(exchange)));
                break;
            }
            case HSETNX: {
                this.setResult(exchange, redisClient.hsetnx(this.getKey(exchange), this.getField(exchange), this.getValue(exchange)));
                break;
            }
            case HMSET: {
                redisClient.hmset(this.getKey(exchange), this.getValuesAsMap(exchange));
                break;
            }
            case HMGET: {
                this.setResult(exchange, redisClient.hmget(this.getKey(exchange), this.getFields(exchange)));
                break;
            }
            case HINCRBY: {
                this.setResult(exchange, redisClient.hincrBy(this.getKey(exchange), this.getField(exchange), this.getValueAsLong(exchange)));
                break;
            }
            case HEXISTS: {
                this.setResult(exchange, redisClient.hexists(this.getKey(exchange), this.getField(exchange)));
                break;
            }
            case HDEL: {
                redisClient.hdel(this.getKey(exchange), this.getField(exchange));
                break;
            }
            case HLEN: {
                this.setResult(exchange, redisClient.hlen(this.getKey(exchange)));
                break;
            }
            case HKEYS: {
                this.setResult(exchange, redisClient.hkeys(this.getKey(exchange)));
                break;
            }
            case HVALS: {
                this.setResult(exchange, redisClient.hvals(this.getKey(exchange)));
                break;
            }
            case HGETALL: {
                this.setResult(exchange, redisClient.hgetAll(this.getKey(exchange)));
                break;
            }
            case RPUSH: {
                this.setResult(exchange, redisClient.rpush(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case LPUSH: {
                this.setResult(exchange, redisClient.lpush(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case LLEN: {
                this.setResult(exchange, redisClient.llen(this.getKey(exchange)));
                break;
            }
            case LRANGE: {
                this.setResult(exchange, redisClient.lrange(this.getKey(exchange), this.getStart(exchange), this.getEnd(exchange)));
                break;
            }
            case LTRIM: {
                redisClient.ltrim(this.getKey(exchange), this.getStart(exchange), this.getEnd(exchange));
                break;
            }
            case LINDEX: {
                this.setResult(exchange, redisClient.lindex(this.getKey(exchange), this.getIndex(exchange)));
                break;
            }
            case LSET: {
                redisClient.lset(this.getKey(exchange), this.getValue(exchange), this.getIndex(exchange));
                break;
            }
            case LREM: {
                this.setResult(exchange, redisClient.lrem(this.getKey(exchange), this.getValue(exchange), this.getCount(exchange)));
                break;
            }
            case LPOP: {
                this.setResult(exchange, redisClient.lpop(this.getKey(exchange)));
                break;
            }
            case RPOP: {
                this.setResult(exchange, redisClient.rpop(this.getKey(exchange)));
                break;
            }
            case RPOPLPUSH: {
                this.setResult(exchange, redisClient.rpoplpush(this.getKey(exchange), this.getDestination(exchange)));
                break;
            }
            case SADD: {
                this.setResult(exchange, redisClient.sadd(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case SMEMBERS: {
                this.setResult(exchange, redisClient.smembers(this.getKey(exchange)));
                break;
            }
            case SREM: {
                this.setResult(exchange, redisClient.srem(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case SPOP: {
                this.setResult(exchange, redisClient.spop(this.getKey(exchange)));
                break;
            }
            case SMOVE: {
                this.setResult(exchange, redisClient.smove(this.getKey(exchange), this.getValue(exchange), this.getDestination(exchange)));
                break;
            }
            case SCARD: {
                this.setResult(exchange, redisClient.scard(this.getKey(exchange)));
                break;
            }
            case SISMEMBER: {
                this.setResult(exchange, redisClient.sismember(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case SINTER: {
                this.setResult(exchange, redisClient.sinter(this.getKey(exchange), this.getKeys(exchange)));
                break;
            }
            case SINTERSTORE: {
                redisClient.sinterstore(this.getKey(exchange), this.getKeys(exchange), this.getDestination(exchange));
                break;
            }
            case SUNION: {
                this.setResult(exchange, redisClient.sunion(this.getKey(exchange), this.getKeys(exchange)));
                break;
            }
            case SUNIONSTORE: {
                redisClient.sunionstore(this.getKey(exchange), this.getKeys(exchange), this.getDestination(exchange));
                break;
            }
            case SDIFF: {
                this.setResult(exchange, redisClient.sdiff(this.getKey(exchange), this.getKeys(exchange)));
                break;
            }
            case SDIFFSTORE: {
                redisClient.sdiffstore(this.getKey(exchange), this.getKeys(exchange), this.getDestination(exchange));
                break;
            }
            case SRANDMEMBER: {
                this.setResult(exchange, redisClient.srandmember(this.getKey(exchange)));
                break;
            }
            case ZADD: {
                this.setResult(exchange, redisClient.zadd(this.getKey(exchange), this.getValue(exchange), this.getScore(exchange)));
                break;
            }
            case ZRANGE: {
                this.setResult(exchange, redisClient.zrange(this.getKey(exchange), this.getStart(exchange), this.getEnd(exchange), this.getWithScore(exchange)));
                break;
            }
            case ZREM: {
                this.setResult(exchange, redisClient.zrem(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case ZINCRBY: {
                this.setResult(exchange, redisClient.zincrby(this.getKey(exchange), this.getValue(exchange), this.getIncrement(exchange)));
                break;
            }
            case ZRANK: {
                this.setResult(exchange, redisClient.zrank(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case ZREVRANK: {
                this.setResult(exchange, redisClient.zrevrank(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case ZREVRANGE: {
                this.setResult(exchange, redisClient.zrevrange(this.getKey(exchange), this.getStart(exchange), this.getEnd(exchange), this.getWithScore(exchange)));
                break;
            }
            case ZCARD: {
                this.setResult(exchange, redisClient.zcard(this.getKey(exchange)));
                break;
            }
            case MULTI: {
                redisClient.multi();
                break;
            }
            case DISCARD: {
                redisClient.discard();
                break;
            }
            case EXEC: {
                redisClient.exec();
                break;
            }
            case WATCH: {
                redisClient.watch(this.getKeys(exchange));
                break;
            }
            case UNWATCH: {
                redisClient.unwatch();
                break;
            }
            case SORT: {
                this.setResult(exchange, redisClient.sort(this.getKey(exchange)));
                break;
            }
            case BLPOP: {
                this.setResult(exchange, redisClient.blpop(this.getKey(exchange), this.getTimeout(exchange)));
                break;
            }
            case BRPOP: {
                this.setResult(exchange, redisClient.brpop(this.getKey(exchange), this.getTimeout(exchange)));
                break;
            }
            case PUBLISH: {
                redisClient.publish(this.getChannel(exchange), this.getMessage(exchange));
                break;
            }
            case ZCOUNT: {
                this.setResult(exchange, redisClient.zcount(this.getKey(exchange), this.getMin(exchange), this.getMax(exchange)));
                break;
            }
            case ZRANGEBYSCORE: {
                this.setResult(exchange, redisClient.zrangebyscore(this.getKey(exchange), this.getMin(exchange), this.getMax(exchange)));
                break;
            }
            case ZREVRANGEBYSCORE: {
                this.setResult(exchange, redisClient.zrevrangebyscore(this.getKey(exchange), this.getMin(exchange), this.getMax(exchange)));
                break;
            }
            case ZREMRANGEBYRANK: {
                redisClient.zremrangebyrank(this.getKey(exchange), this.getStart(exchange), this.getEnd(exchange));
                break;
            }
            case ZREMRANGEBYSCORE: {
                redisClient.zremrangebyscore(this.getKey(exchange), this.getStart(exchange), this.getEnd(exchange));
                break;
            }
            case ZUNIONSTORE: {
                redisClient.zunionstore(this.getKey(exchange), this.getKeys(exchange), this.getDestination(exchange));
                break;
            }
            case ZINTERSTORE: {
                redisClient.zinterstore(this.getKey(exchange), this.getKeys(exchange), this.getDestination(exchange));
                break;
            }
            case STRLEN: {
                this.setResult(exchange, redisClient.strlen(this.getKey(exchange)));
                break;
            }
            case PERSIST: {
                this.setResult(exchange, redisClient.persist(this.getKey(exchange)));
                break;
            }
            case RPUSHX: {
                this.setResult(exchange, redisClient.rpushx(this.getKey(exchange), this.getValue(exchange)));
                break;
            }
            case ECHO: {
                this.setResult(exchange, redisClient.echo(this.getStringValue(exchange)));
                break;
            }
            case LINSERT: {
                this.setResult(exchange, redisClient.linsert(this.getKey(exchange), this.getValue(exchange), this.getPivot(exchange), this.getPosition(exchange)));
                break;
            }
            case BRPOPLPUSH: {
                this.setResult(exchange, redisClient.brpoplpush(this.getKey(exchange), this.getDestination(exchange), this.getTimeout(exchange)));
                break;
            }
            case SETBIT: {
                redisClient.setbit(this.getKey(exchange), this.getOffset(exchange), this.getBooleanValue(exchange));
                break;
            }
            case GETBIT: {
                this.setResult(exchange, redisClient.getbit(this.getKey(exchange), this.getOffset(exchange)));
                break;
            }
            case SETRANGE: {
                redisClient.setex(this.getKey(exchange), this.getValue(exchange), this.getOffset(exchange));
                break;
            }
            case GETRANGE: {
                this.setResult(exchange, redisClient.getrange(this.getKey(exchange), this.getStart(exchange), this.getEnd(exchange)));
                break;
            }
            default: {
                throw new RuntimeExchangeException("Unsupported command: " + (Object)((Object)command), exchange);
            }
        }
    }

    private Command determineCommand(Exchange exchange) {
        Command command = (Command)((Object)exchange.getIn().getHeader("CamelRedis.Command", Command.class));
        if (command == null) {
            command = this.configuration.getCommand();
        }
        if (command == null) {
            command = Command.SET;
        }
        return command;
    }

    private static <T> T getInHeaderValue(Exchange exchange, String key, Class<T> aClass) {
        return (T)exchange.getIn().getHeader(key, aClass);
    }

    private void setResult(Exchange exchange, Object result) {
        Message message;
        if (exchange.getPattern().isOutCapable()) {
            message = exchange.getOut();
            message.copyFrom(exchange.getIn());
        } else {
            message = exchange.getIn();
        }
        message.setBody(result);
    }

    public String getDestination(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Destination", String.class);
    }

    private String getChannel(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Channel", String.class);
    }

    private Object getMessage(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Message", Object.class);
    }

    public Long getIndex(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Index", Long.class);
    }

    public String getPivot(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Pivot", String.class);
    }

    public String getPosition(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Position", String.class);
    }

    public Long getCount(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Count", Long.class);
    }

    private Long getStart(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Start", Long.class);
    }

    private Long getEnd(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.End", Long.class);
    }

    private Long getTimeout(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Timeout", Long.class);
    }

    private Long getOffset(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Offset", Long.class);
    }

    private Long getValueAsLong(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Value", Long.class);
    }

    private Collection<String> getFields(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Fields", Collection.class);
    }

    private Map<String, Object> getValuesAsMap(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Values", Map.class);
    }

    private String getKey(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Key", String.class);
    }

    public Collection<String> getKeys(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Keys", Collection.class);
    }

    private Object getValue(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Value", Object.class);
    }

    private String getStringValue(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Value", String.class);
    }

    private Long getLongValue(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Value", Long.class);
    }

    private Boolean getBooleanValue(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Value", Boolean.class);
    }

    private String getField(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Field", String.class);
    }

    public Long getTimestamp(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Timestamp", Long.class);
    }

    public String getPattern(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Pattern", String.class);
    }

    public Integer getDb(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Db", Integer.class);
    }

    public Double getScore(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Score", Double.class);
    }

    public Double getMin(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Min", Double.class);
    }

    public Double getMax(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Max", Double.class);
    }

    public Double getIncrement(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.Increment", Double.class);
    }

    public Boolean getWithScore(Exchange exchange) {
        return CommandDispatcher.getInHeaderValue(exchange, "CamelRedis.WithScore", Boolean.class);
    }
}

