/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.sparkrest.CamelSpark;
import org.apache.camel.component.sparkrest.DefaultSparkBinding;
import org.apache.camel.component.sparkrest.SparkBinding;
import org.apache.camel.component.sparkrest.SparkConfiguration;
import org.apache.camel.component.sparkrest.SparkEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class SparkComponent
extends UriEndpointComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    private final Pattern pattern = Pattern.compile("\\{(.*?)\\}");
    private int port = 4567;
    private String ipAddress;
    private int minThreads;
    private int maxThreads;
    private int timeOutMillis;
    private String keystoreFile;
    private String keystorePassword;
    private String truststoreFile;
    private String truststorePassword;
    private SparkConfiguration sparkConfiguration = new SparkConfiguration();
    private SparkBinding sparkBinding = new DefaultSparkBinding();

    public SparkComponent() {
        super(SparkEndpoint.class);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getTimeOutMillis() {
        return this.timeOutMillis;
    }

    public void setTimeOutMillis(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststoreFile(String truststoreFile) {
        this.truststoreFile = truststoreFile;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public SparkConfiguration getSparkConfiguration() {
        return this.sparkConfiguration;
    }

    public void setSparkConfiguration(SparkConfiguration sparkConfiguration) {
        this.sparkConfiguration = sparkConfiguration;
    }

    public SparkBinding getSparkBinding() {
        return this.sparkBinding;
    }

    public void setSparkBinding(SparkBinding sparkBinding) {
        this.sparkBinding = sparkBinding;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SparkConfiguration config = this.getSparkConfiguration().copy();
        this.setProperties(config, parameters);
        SparkEndpoint answer = new SparkEndpoint(uri, (Component)this);
        answer.setSparkConfiguration(config);
        answer.setSparkBinding(this.getSparkBinding());
        this.setProperties((Object)answer, parameters);
        if (!remaining.contains(":")) {
            throw new IllegalArgumentException("Invalid syntax. Must be spark-rest:verb:path");
        }
        String verb = ObjectHelper.before((String)remaining, (String)":");
        String path = ObjectHelper.after((String)remaining, (String)":");
        answer.setVerb(verb);
        answer.setPath(path);
        return answer;
    }

    protected void doStart() throws Exception {
        RestConfiguration config;
        super.doStart();
        if (this.getPort() != 4567) {
            CamelSpark.port(this.getPort());
        } else {
            RestConfiguration config2 = this.getCamelContext().getRestConfiguration("spark-rest", true);
            int port = config2.getPort();
            if (port > 0) {
                CamelSpark.port(port);
            }
        }
        String host = this.getIpAddress();
        if (host != null) {
            CamelSpark.ipAddress(host);
        } else {
            RestConfiguration config3 = this.getCamelContext().getRestConfiguration("spark-rest", true);
            host = config3.getHost();
            if (ObjectHelper.isEmpty((Object)host)) {
                if (config3.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                    host = "0.0.0.0";
                } else if (config3.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                    host = HostUtils.getLocalHostName();
                } else if (config3.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                    host = HostUtils.getLocalIp();
                }
            }
            CamelSpark.ipAddress(host);
        }
        if (this.keystoreFile != null || this.truststoreFile != null) {
            CamelSpark.security(this.keystoreFile, this.keystorePassword, this.truststoreFile, this.truststorePassword);
        }
        if ((config = this.getCamelContext().getRestConfiguration("spark-rest", true)).getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties(this.sparkConfiguration, config.getComponentProperties());
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        CamelSpark.stop();
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "get", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String contextPath;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("spark-rest", true);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (consumes != null) {
            map.put("accept", consumes);
        }
        if (config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (ObjectHelper.isNotEmpty((Object)path)) {
            Matcher matcher = this.pattern.matcher(path);
            path = matcher.replaceAll(":$1");
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        String url = api ? "spark-rest:%s:%s?matchOnUriPrefix=true" : "spark-rest:%s:%s";
        url = String.format(url, verb, path);
        String query = URISupport.createQueryString(map);
        if (!query.isEmpty()) {
            url = url + "?" + query;
        }
        SparkEndpoint endpoint = (SparkEndpoint)camelContext.getEndpoint(url, SparkEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.isEnableCORS()) {
            if (config.getConsumerProperties() == null) {
                config.setConsumerProperties(new HashMap());
            }
            config.getConsumerProperties().put("enableCors", true);
        }
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }
}

