/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TestProxy {
    TestProxy() {
    }

    public String sayHi() {
        return "Hello!";
    }

    public String sayHi(String name) {
        return "Hello " + name;
    }

    public final String greetMe(String name) {
        return "Greetings " + name;
    }

    public final String greetUs(String name1, String name2) {
        return "Greetings " + name1 + ", " + name2;
    }

    public final String greetAll(String[] names) {
        StringBuilder builder = new StringBuilder("Greetings ");
        for (String name : names) {
            builder.append(name).append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    public final String greetAll(List<String> names) {
        StringBuilder builder = new StringBuilder("Greetings ");
        for (String name : names) {
            builder.append(name).append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    public final String[] greetTimes(String name, int times) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < times; ++i) {
            result.add("Greetings " + name);
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<String, String> greetAll(Map<String, String> nameMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : nameMap.entrySet()) {
            String name = entry.getKey();
            String greeting = entry.getValue();
            result.put(name, greeting + " " + name);
        }
        return result;
    }

    public final String greetInnerChild(InnerChild child) {
        return this.sayHi(child.getName());
    }

    public static class InnerChild {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

