/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;
import org.apache.camel.util.component.ApiMethodImpl;
import org.apache.camel.util.component.TestProxy;
import org.junit.Assert;
import org.junit.Test;

public class ApiMethodHelperTest {
    private static TestMethod[] sayHis = new TestMethod[]{TestMethod.SAYHI, TestMethod.SAYHI_1};
    private static ApiMethodHelper<TestMethod> apiMethodHelper;

    @Test
    public void testGetCandidateMethods() {
        List methods = apiMethodHelper.getCandidateMethods("sayHi", new String[0]);
        Assert.assertEquals((String)"Can't find sayHi(*)", (long)2L, (long)methods.size());
        methods = apiMethodHelper.getCandidateMethods("hi", new String[0]);
        Assert.assertEquals((String)"Can't find sayHi(name)", (long)2L, (long)methods.size());
        methods = apiMethodHelper.getCandidateMethods("hi", new String[]{"name"});
        Assert.assertEquals((String)"Can't find sayHi(name)", (long)1L, (long)methods.size());
        methods = apiMethodHelper.getCandidateMethods("greetMe", new String[0]);
        Assert.assertEquals((String)"Can't find greetMe(name)", (long)1L, (long)methods.size());
        methods = apiMethodHelper.getCandidateMethods("greetUs", new String[]{"name1"});
        Assert.assertEquals((String)"Can't find greetUs(name1, name2)", (long)1L, (long)methods.size());
        methods = apiMethodHelper.getCandidateMethods("greetAll", new String[]{"nameMap"});
        Assert.assertEquals((String)"Can't find greetAll(nameMap)", (long)1L, (long)methods.size());
        methods = apiMethodHelper.getCandidateMethods("greetInnerChild", new String[]{"child"});
        Assert.assertEquals((String)"Can't find greetInnerChild(child)", (long)1L, (long)methods.size());
    }

    @Test
    public void testFilterMethods() {
        List methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.EXACT, new String[0]);
        Assert.assertEquals((String)"Exact match failed for sayHi()", (long)1L, (long)methods.size());
        Assert.assertEquals((String)"Exact match failed for sayHi()", (Object)((Object)TestMethod.SAYHI), methods.get(0));
        methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.SUBSET, new String[0]);
        Assert.assertEquals((String)"Subset match failed for sayHi(*)", (long)2L, (long)methods.size());
        methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.SUBSET, new String[]{"name"});
        Assert.assertEquals((String)"Subset match failed for sayHi(name)", (long)1L, (long)methods.size());
        Assert.assertEquals((String)"Exact match failed for sayHi()", (Object)((Object)TestMethod.SAYHI_1), methods.get(0));
        methods = apiMethodHelper.filterMethods(Arrays.asList(sayHis), ApiMethodHelper.MatchType.SUPER_SET, new String[]{"name"});
        Assert.assertEquals((String)"Super set match failed for sayHi(name)", (long)1L, (long)methods.size());
        Assert.assertEquals((String)"Exact match failed for sayHi()", (Object)((Object)TestMethod.SAYHI_1), methods.get(0));
        methods = apiMethodHelper.filterMethods(Arrays.asList(TestMethod.values()), ApiMethodHelper.MatchType.SUPER_SET, new String[]{"name"});
        Assert.assertEquals((String)"Super set match failed for sayHi(name)", (long)2L, (long)methods.size());
        methods = apiMethodHelper.filterMethods(Arrays.asList(TestMethod.GREETALL, TestMethod.GREETALL_1, TestMethod.GREETALL_2), ApiMethodHelper.MatchType.SUPER_SET, new String[0]);
        Assert.assertEquals((String)"Super set match with null args failed for greetAll(names)", (long)1L, (long)methods.size());
    }

    @Test
    public void testGetArguments() {
        Assert.assertEquals((String)"GetArguments failed for hi", (long)2L, (long)apiMethodHelper.getArguments("hi").size());
        Assert.assertEquals((String)"GetArguments failed for greetMe", (long)2L, (long)apiMethodHelper.getArguments("greetMe").size());
        Assert.assertEquals((String)"GetArguments failed for greetUs", (long)4L, (long)apiMethodHelper.getArguments("greetUs").size());
        Assert.assertEquals((String)"GetArguments failed for greetAll", (long)6L, (long)apiMethodHelper.getArguments("greetAll").size());
        Assert.assertEquals((String)"GetArguments failed for greetInnerChild", (long)2L, (long)apiMethodHelper.getArguments("greetInnerChild").size());
    }

    @Test
    public void testGetMissingProperties() throws Exception {
        Assert.assertEquals((String)"Missing properties for hi", (long)1L, (long)apiMethodHelper.getMissingProperties("hi", new HashSet()).size());
        HashSet<String> argNames = new HashSet<String>();
        argNames.add("name");
        Assert.assertEquals((String)"Missing properties for greetMe", (long)0L, (long)apiMethodHelper.getMissingProperties("greetMe", argNames).size());
        argNames.clear();
        argNames.add("name1");
        Assert.assertEquals((String)"Missing properties for greetMe", (long)1L, (long)apiMethodHelper.getMissingProperties("greetUs", argNames).size());
    }

    @Test
    public void testAllArguments() throws Exception {
        Assert.assertEquals((String)"Get all arguments", (long)8L, (long)apiMethodHelper.allArguments().size());
    }

    @Test
    public void testGetType() throws Exception {
        Assert.assertEquals((String)"Get type name", String.class, (Object)apiMethodHelper.getType("name"));
        Assert.assertEquals((String)"Get type name1", String.class, (Object)apiMethodHelper.getType("name1"));
        Assert.assertEquals((String)"Get type name2", String.class, (Object)apiMethodHelper.getType("name2"));
        Assert.assertEquals((String)"Get type nameMap", Map.class, (Object)apiMethodHelper.getType("nameMap"));
        Assert.assertEquals((String)"Get type child", TestProxy.InnerChild.class, (Object)apiMethodHelper.getType("child"));
    }

    @Test
    public void testGetHighestPriorityMethod() throws Exception {
        Assert.assertEquals((String)"Get highest priority method", (Object)((Object)TestMethod.SAYHI_1), (Object)ApiMethodHelper.getHighestPriorityMethod(Arrays.asList(sayHis)));
    }

    @Test
    public void testInvokeMethod() throws Exception {
        TestProxy proxy = new TestProxy();
        Assert.assertEquals((String)"sayHi()", (Object)"Hello!", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.SAYHI, Collections.emptyMap()));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", "Dave");
        Assert.assertEquals((String)"sayHi(name)", (Object)"Hello Dave", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.SAYHI_1, properties));
        Assert.assertEquals((String)"greetMe(name)", (Object)"Greetings Dave", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETME, properties));
        properties.clear();
        properties.put("name1", "Dave");
        properties.put("name2", "Frank");
        Assert.assertEquals((String)"greetUs(name1, name2)", (Object)"Greetings Dave, Frank", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETUS, properties));
        properties.clear();
        properties.put("names", new String[]{"Dave", "Frank"});
        Assert.assertEquals((String)"greetAll(names)", (Object)"Greetings Dave, Frank", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETALL, properties));
        properties.clear();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("Dave", "Hello");
        nameMap.put("Frank", "Goodbye");
        properties.put("nameMap", nameMap);
        Map result = (Map)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.GREETALL_2, properties);
        Assert.assertNotNull((String)"greetAll(nameMap)", (Object)result);
        for (Map.Entry entry : result.entrySet()) {
            Assert.assertTrue((String)"greetAll(nameMap)", (boolean)((String)entry.getValue()).endsWith((String)entry.getKey()));
        }
        proxy = new TestProxy(){

            @Override
            public String sayHi(String name) {
                return "Howdy " + name;
            }
        };
        properties.clear();
        properties.put("name", "Dave");
        Assert.assertEquals((String)"Derived sayHi(name)", (Object)"Howdy Dave", (Object)ApiMethodHelper.invokeMethod((Object)proxy, (ApiMethod)TestMethod.SAYHI_1, properties));
    }

    static {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("say(.*)", "$1");
        apiMethodHelper = new ApiMethodHelper(TestMethod.class, aliases, Arrays.asList("names"));
    }

    static enum TestMethod implements ApiMethod
    {
        SAYHI(String.class, "sayHi", new Object[0]),
        SAYHI_1(String.class, "sayHi", String.class, "name"),
        GREETME(String.class, "greetMe", String.class, "name"),
        GREETUS(String.class, "greetUs", String.class, "name1", String.class, "name2"),
        GREETALL(String.class, "greetAll", new String[0].getClass(), "names"),
        GREETALL_1(String.class, "greetAll", List.class, "nameList"),
        GREETALL_2(Map.class, "greetAll", Map.class, "nameMap"),
        GREETTIMES(new String[0].getClass(), "greetTimes", String.class, "name", Integer.TYPE, "times"),
        GREETINNERCHILD(new String[0].getClass(), "greetInnerChild", TestProxy.InnerChild.class, "child");

        private final ApiMethod apiMethod;

        private TestMethod(Class<?> resultType, String name, Object ... args) {
            this.apiMethod = new ApiMethodImpl(TestProxy.class, resultType, name, args);
        }

        public String getName() {
            return this.apiMethod.getName();
        }

        public Class<?> getResultType() {
            return this.apiMethod.getResultType();
        }

        public List<String> getArgNames() {
            return this.apiMethod.getArgNames();
        }

        public List<Class<?>> getArgTypes() {
            return this.apiMethod.getArgTypes();
        }

        public Method getMethod() {
            return this.apiMethod.getMethod();
        }
    }
}

