/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import junit.framework.TestCase;
import org.apache.camel.util.StringHelper;

public class StringHelperTest
extends TestCase {
    public void testSimpleSanitized() {
        String out = StringHelper.sanitize((String)"hello");
        StringHelperTest.assertTrue((String)"Should not contain : ", (out.indexOf(58) == -1 ? 1 : 0) != 0);
        StringHelperTest.assertTrue((String)"Should not contain . ", (out.indexOf(46) == -1 ? 1 : 0) != 0);
    }

    public void testNotFileFriendlySimpleSanitized() {
        String out = StringHelper.sanitize((String)"c:\\helloworld");
        StringHelperTest.assertTrue((String)"Should not contain : ", (out.indexOf(58) == -1 ? 1 : 0) != 0);
        StringHelperTest.assertTrue((String)"Should not contain . ", (out.indexOf(46) == -1 ? 1 : 0) != 0);
    }

    public void testCountChar() {
        StringHelperTest.assertEquals((int)0, (int)StringHelper.countChar((String)"Hello World", (char)'x'));
        StringHelperTest.assertEquals((int)1, (int)StringHelper.countChar((String)"Hello World", (char)'e'));
        StringHelperTest.assertEquals((int)3, (int)StringHelper.countChar((String)"Hello World", (char)'l'));
        StringHelperTest.assertEquals((int)1, (int)StringHelper.countChar((String)"Hello World", (char)' '));
        StringHelperTest.assertEquals((int)0, (int)StringHelper.countChar((String)"", (char)' '));
        StringHelperTest.assertEquals((int)0, (int)StringHelper.countChar(null, (char)' '));
    }

    public void testRemoveQuotes() throws Exception {
        StringHelperTest.assertEquals((String)"Hello World", (String)StringHelper.removeQuotes((String)"Hello World"));
        StringHelperTest.assertEquals((String)"", (String)StringHelper.removeQuotes((String)""));
        StringHelperTest.assertEquals(null, (String)StringHelper.removeQuotes(null));
        StringHelperTest.assertEquals((String)" ", (String)StringHelper.removeQuotes((String)" "));
        StringHelperTest.assertEquals((String)"foo", (String)StringHelper.removeQuotes((String)"'foo'"));
        StringHelperTest.assertEquals((String)"foo", (String)StringHelper.removeQuotes((String)"'foo"));
        StringHelperTest.assertEquals((String)"foo", (String)StringHelper.removeQuotes((String)"foo'"));
        StringHelperTest.assertEquals((String)"foo", (String)StringHelper.removeQuotes((String)"\"foo\""));
        StringHelperTest.assertEquals((String)"foo", (String)StringHelper.removeQuotes((String)"\"foo"));
        StringHelperTest.assertEquals((String)"foo", (String)StringHelper.removeQuotes((String)"foo\""));
        StringHelperTest.assertEquals((String)"foo", (String)StringHelper.removeQuotes((String)"'foo\""));
    }

    public void testRemoveLeadingAndEndingQuotes() throws Exception {
        StringHelperTest.assertEquals(null, (String)StringHelper.removeLeadingAndEndingQuotes(null));
        StringHelperTest.assertEquals((String)"", (String)StringHelper.removeLeadingAndEndingQuotes((String)""));
        StringHelperTest.assertEquals((String)" ", (String)StringHelper.removeLeadingAndEndingQuotes((String)" "));
        StringHelperTest.assertEquals((String)"Hello World", (String)StringHelper.removeLeadingAndEndingQuotes((String)"Hello World"));
        StringHelperTest.assertEquals((String)"Hello World", (String)StringHelper.removeLeadingAndEndingQuotes((String)"'Hello World'"));
        StringHelperTest.assertEquals((String)"Hello World", (String)StringHelper.removeLeadingAndEndingQuotes((String)"\"Hello World\""));
        StringHelperTest.assertEquals((String)"Hello 'Camel'", (String)StringHelper.removeLeadingAndEndingQuotes((String)"Hello 'Camel'"));
    }

    public void testHasUpper() throws Exception {
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasUpperCase(null));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasUpperCase((String)""));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasUpperCase((String)" "));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasUpperCase((String)"com.foo"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasUpperCase((String)"com.foo.123"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.hasUpperCase((String)"com.foo.MyClass"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.hasUpperCase((String)"com.foo.My"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.hasUpperCase((String)"com.foo.subA"));
    }

    public void testIsClassName() throws Exception {
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isClassName(null));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isClassName((String)""));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isClassName((String)" "));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isClassName((String)"com.foo"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isClassName((String)"com.foo.123"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.isClassName((String)"com.foo.MyClass"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.isClassName((String)"com.foo.My"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isClassName((String)"com.foo.subA"));
    }

    public void testHasStartToken() throws Exception {
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken(null, null));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken(null, (String)"simple"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken((String)"", null));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken((String)"", (String)"simple"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken((String)"Hello World", null));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken((String)"Hello World", (String)"simple"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken((String)"${body}", null));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.hasStartToken((String)"${body}", (String)"simple"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.hasStartToken((String)"$simple{body}", (String)"simple"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken((String)"${body}", null));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.hasStartToken((String)"${body}", (String)"foo"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.hasStartToken((String)"$foo{body}", (String)"foo"));
    }

    public void testIsQuoted() throws Exception {
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted(null));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)""));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)" "));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"abc"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"abc'"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"\"abc'"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"abc\""));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"'abc\""));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"\"abc'"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"abc'def'"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"abc'def'ghi"));
        StringHelperTest.assertEquals((boolean)false, (boolean)StringHelper.isQuoted((String)"'def'ghi"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.isQuoted((String)"'abc'"));
        StringHelperTest.assertEquals((boolean)true, (boolean)StringHelper.isQuoted((String)"\"abc\""));
    }

    public void testReplaceAll() throws Exception {
        StringHelperTest.assertEquals((String)"", (String)StringHelper.replaceAll((String)"", (String)"", (String)""));
        StringHelperTest.assertEquals(null, (String)StringHelper.replaceAll(null, (String)"", (String)""));
        StringHelperTest.assertEquals((String)"foobar", (String)StringHelper.replaceAll((String)"foobar", (String)"###", (String)"DOT"));
        StringHelperTest.assertEquals((String)"foobar", (String)StringHelper.replaceAll((String)"foo.bar", (String)".", (String)""));
        StringHelperTest.assertEquals((String)"fooDOTbar", (String)StringHelper.replaceAll((String)"foo.bar", (String)".", (String)"DOT"));
        StringHelperTest.assertEquals((String)"fooDOTbar", (String)StringHelper.replaceAll((String)"foo###bar", (String)"###", (String)"DOT"));
        StringHelperTest.assertEquals((String)"foobar", (String)StringHelper.replaceAll((String)"foo###bar", (String)"###", (String)""));
        StringHelperTest.assertEquals((String)"fooDOTbarDOTbaz", (String)StringHelper.replaceAll((String)"foo.bar.baz", (String)".", (String)"DOT"));
        StringHelperTest.assertEquals((String)"fooDOTbarDOTbazDOT", (String)StringHelper.replaceAll((String)"foo.bar.baz.", (String)".", (String)"DOT"));
        StringHelperTest.assertEquals((String)"DOTfooDOTbarDOTbazDOT", (String)StringHelper.replaceAll((String)".foo.bar.baz.", (String)".", (String)"DOT"));
        StringHelperTest.assertEquals((String)"fooDOT", (String)StringHelper.replaceAll((String)"foo.", (String)".", (String)"DOT"));
    }
}

