/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.ExchangeHelper;

public class ExchangeHelperTest
extends ContextTestSupport {
    protected Exchange exchange;

    public void testValidProperty() throws Exception {
        String value = (String)ExchangeHelper.getMandatoryProperty((Exchange)this.exchange, (String)"foo", String.class);
        ExchangeHelperTest.assertEquals((String)"foo property", (String)"123", (String)value);
    }

    public void testMissingProperty() throws Exception {
        try {
            String value = (String)ExchangeHelper.getMandatoryProperty((Exchange)this.exchange, (String)"bar", String.class);
            ExchangeHelperTest.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchPropertyException e) {
            ExchangeHelperTest.assertEquals((String)"bar", (String)e.getPropertyName());
        }
    }

    public void testPropertyOfIncompatibleType() throws Exception {
        try {
            List value = (List)ExchangeHelper.getMandatoryProperty((Exchange)this.exchange, (String)"foo", List.class);
            ExchangeHelperTest.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchPropertyException e) {
            ExchangeHelperTest.assertEquals((String)"foo", (String)e.getPropertyName());
        }
    }

    public void testMissingHeader() throws Exception {
        try {
            String value = (String)ExchangeHelper.getMandatoryHeader((Exchange)this.exchange, (String)"unknown", String.class);
            ExchangeHelperTest.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchHeaderException e) {
            ExchangeHelperTest.assertEquals((String)"unknown", (String)e.getHeaderName());
        }
    }

    public void testHeaderOfIncompatibleType() throws Exception {
        this.exchange.getIn().setHeader("foo", (Object)123);
        try {
            List value = (List)ExchangeHelper.getMandatoryHeader((Exchange)this.exchange, (String)"foo", List.class);
            ExchangeHelperTest.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchHeaderException e) {
            ExchangeHelperTest.assertEquals((String)"foo", (String)e.getHeaderName());
        }
    }

    public void testNoSuchBean() throws Exception {
        try {
            ExchangeHelper.lookupMandatoryBean((Exchange)this.exchange, (String)"foo");
            ExchangeHelperTest.fail((String)"Should have thrown an exception");
        }
        catch (NoSuchBeanException e) {
            ExchangeHelperTest.assertEquals((String)"No bean could be found in the registry for: foo", (String)e.getMessage());
            ExchangeHelperTest.assertEquals((String)"foo", (String)e.getName());
        }
    }

    public void testNoSuchBeanType() throws Exception {
        try {
            ExchangeHelper.lookupMandatoryBean((Exchange)this.exchange, (String)"foo", String.class);
            ExchangeHelperTest.fail((String)"Should have thrown an exception");
        }
        catch (NoSuchBeanException e) {
            ExchangeHelperTest.assertEquals((String)"No bean could be found in the registry for: foo", (String)e.getMessage());
            ExchangeHelperTest.assertEquals((String)"foo", (String)e.getName());
        }
    }

    public void testGetExchangeById() throws Exception {
        ArrayList<Exchange> list = new ArrayList<Exchange>();
        Exchange e1 = this.context.getEndpoint("mock:foo").createExchange();
        Exchange e2 = this.context.getEndpoint("mock:foo").createExchange();
        list.add(e1);
        list.add(e2);
        ExchangeHelperTest.assertNull((Object)ExchangeHelper.getExchangeById(list, (String)"unknown"));
        ExchangeHelperTest.assertEquals((Object)e1, (Object)ExchangeHelper.getExchangeById(list, (String)e1.getExchangeId()));
        ExchangeHelperTest.assertEquals((Object)e2, (Object)ExchangeHelper.getExchangeById(list, (String)e2.getExchangeId()));
    }

    public void testPopulateVariableMap() throws Exception {
        this.exchange.setPattern(ExchangePattern.InOut);
        this.exchange.getOut().setBody((Object)"bar");
        this.exchange.getOut().setHeader("quote", (Object)"Camel rocks");
        HashMap map = new HashMap();
        ExchangeHelper.populateVariableMap((Exchange)this.exchange, map);
        ExchangeHelperTest.assertEquals((int)8, (int)map.size());
        ExchangeHelperTest.assertSame((Object)this.exchange, map.get("exchange"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("in"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("request"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getOut(), map.get("out"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getOut(), map.get("response"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("headers"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn().getBody(), map.get("body"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getContext(), map.get("camelContext"));
    }

    public void testCreateVariableMap() throws Exception {
        this.exchange.setPattern(ExchangePattern.InOut);
        this.exchange.getOut().setBody((Object)"bar");
        this.exchange.getOut().setHeader("quote", (Object)"Camel rocks");
        Map map = ExchangeHelper.createVariableMap((Exchange)this.exchange);
        ExchangeHelperTest.assertEquals((int)8, (int)map.size());
        ExchangeHelperTest.assertSame((Object)this.exchange, map.get("exchange"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("in"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("request"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getOut(), map.get("out"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getOut(), map.get("response"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("headers"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn().getBody(), map.get("body"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getContext(), map.get("camelContext"));
    }

    public void testCreateVariableMapNoExistingOut() throws Exception {
        this.exchange.setPattern(ExchangePattern.InOut);
        this.exchange.getIn().setBody((Object)"bar");
        this.exchange.getIn().setHeader("quote", (Object)"Camel rocks");
        ExchangeHelperTest.assertFalse((boolean)this.exchange.hasOut());
        Map map = ExchangeHelper.createVariableMap((Exchange)this.exchange);
        ExchangeHelperTest.assertEquals((int)8, (int)map.size());
        ExchangeHelperTest.assertSame((Object)this.exchange, map.get("exchange"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("in"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("request"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("out"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn(), map.get("response"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("headers"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getIn().getBody(), map.get("body"));
        ExchangeHelperTest.assertSame((Object)this.exchange.getContext(), map.get("camelContext"));
        ExchangeHelperTest.assertFalse((boolean)this.exchange.hasOut());
    }

    public void testGetContentType() throws Exception {
        this.exchange.getIn().setHeader("Content-Type", (Object)"text/xml");
        ExchangeHelperTest.assertEquals((String)"text/xml", (String)ExchangeHelper.getContentType((Exchange)this.exchange));
    }

    public void testGetContentEncpding() throws Exception {
        this.exchange.getIn().setHeader("Content-Encoding", (Object)"iso-8859-1");
        ExchangeHelperTest.assertEquals((String)"iso-8859-1", (String)ExchangeHelper.getContentEncoding((Exchange)this.exchange));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());
        this.exchange.setProperty("foo", (Object)123);
    }
}

