/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.EventObject;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.CamelContextStoppingEvent;
import org.apache.camel.management.event.RouteStartedEvent;
import org.apache.camel.management.event.RouteStoppedEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.Assert;
import org.junit.Test;

public class EventHelperTest {
    @Test
    public void testStartStopEventsReceived() throws Exception {
        MyEventNotifier en1 = new MyEventNotifier();
        MyEventNotifier en2 = new MyEventNotifier();
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("route-1").to("mock:end");
            }
        });
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en1);
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en2);
        camelContext.start();
        camelContext.stop();
        Assert.assertEquals((long)1L, (long)en1.routeStartedEvent.get());
        Assert.assertEquals((long)1L, (long)en1.routeStoppedEvent.get());
        Assert.assertEquals((long)1L, (long)en1.camelContextStoppingEvent.get());
        Assert.assertEquals((long)1L, (long)en2.routeStartedEvent.get());
        Assert.assertEquals((long)1L, (long)en2.routeStoppedEvent.get());
        Assert.assertEquals((long)1L, (long)en2.camelContextStoppingEvent.get());
    }

    @Test
    public void testStartStopEventsReceivedWhenTheFirstOneIgnoreTheseEvents() throws Exception {
        MyEventNotifier en1 = new MyEventNotifier();
        en1.setIgnoreRouteEvents(true);
        en1.setIgnoreCamelContextEvents(true);
        MyEventNotifier en2 = new MyEventNotifier();
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("route-1").to("mock:end");
            }
        });
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en1);
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en2);
        camelContext.start();
        camelContext.stop();
        Assert.assertEquals((long)0L, (long)en1.routeStartedEvent.get());
        Assert.assertEquals((long)0L, (long)en1.routeStoppedEvent.get());
        Assert.assertEquals((long)0L, (long)en1.camelContextStoppingEvent.get());
        Assert.assertEquals((long)1L, (long)en2.routeStartedEvent.get());
        Assert.assertEquals((long)1L, (long)en2.routeStoppedEvent.get());
        Assert.assertEquals((long)1L, (long)en2.camelContextStoppingEvent.get());
    }

    @Test
    public void testStartStopEventsReceivedWhenTheSecondOneIgnoreTheseEvents() throws Exception {
        MyEventNotifier en1 = new MyEventNotifier();
        MyEventNotifier en2 = new MyEventNotifier();
        en2.setIgnoreRouteEvents(true);
        en2.setIgnoreCamelContextEvents(true);
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("route-1").to("mock:end");
            }
        });
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en1);
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en2);
        camelContext.start();
        camelContext.stop();
        Assert.assertEquals((long)1L, (long)en1.routeStartedEvent.get());
        Assert.assertEquals((long)1L, (long)en1.routeStoppedEvent.get());
        Assert.assertEquals((long)1L, (long)en1.camelContextStoppingEvent.get());
        Assert.assertEquals((long)0L, (long)en2.routeStartedEvent.get());
        Assert.assertEquals((long)0L, (long)en2.routeStoppedEvent.get());
        Assert.assertEquals((long)0L, (long)en2.camelContextStoppingEvent.get());
    }

    static class MyEventNotifier
    extends EventNotifierSupport {
        AtomicInteger routeStartedEvent = new AtomicInteger();
        AtomicInteger routeStoppedEvent = new AtomicInteger();
        AtomicInteger camelContextStoppingEvent = new AtomicInteger();

        MyEventNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            if (event instanceof RouteStartedEvent) {
                this.routeStartedEvent.incrementAndGet();
            } else if (event instanceof RouteStoppedEvent) {
                this.routeStoppedEvent.incrementAndGet();
            } else if (event instanceof CamelContextStoppingEvent) {
                this.camelContextStoppingEvent.incrementAndGet();
            }
        }

        public boolean isEnabled(EventObject event) {
            return true;
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

