/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import java.util.EventObject;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;

public class RoutingSlipEventNotifierTest
extends ContextTestSupport {
    private MyEventNotifier notifier = new MyEventNotifier();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    public void testRoutingSlipEventNotifier() throws Exception {
        this.getMockEndpoint("mock:x").expectedMessageCount(1);
        this.getMockEndpoint("mock:y").expectedMessageCount(1);
        this.getMockEndpoint("mock:z").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "myHeader", (Object)"mock:x,mock:y,mock:z");
        this.assertMockEndpointsSatisfied();
        RoutingSlipEventNotifierTest.assertEquals((String)"Should have 5 sending events", (int)5, (int)this.notifier.getSending());
        RoutingSlipEventNotifierTest.assertEquals((String)"Should have 5 sent events", (int)5, (int)this.notifier.getSent());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routingSlip((Expression)this.header("myHeader")).to("mock:end");
            }
        };
    }

    private final class MyEventNotifier
    extends EventNotifierSupport {
        private int sending;
        private int sent;

        private MyEventNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            if (event instanceof ExchangeSendingEvent) {
                ++this.sending;
            } else {
                ++this.sent;
            }
        }

        public boolean isEnabled(EventObject event) {
            return event instanceof ExchangeSendingEvent || event instanceof ExchangeSentEvent;
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }

        public int getSending() {
            return this.sending;
        }

        public int getSent() {
            return this.sent;
        }
    }
}

