/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyOwnHandlerBean;
import org.apache.camel.processor.onexception.MyServiceBean;
import org.apache.camel.processor.onexception.MyTechnicalException;

public class OnExceptionRouteWithDefaultErrorHandlerTest
extends ContextTestSupport {
    private MyOwnHandlerBean myOwnHandlerBean;
    private MyServiceBean myServiceBean;

    public void testNoError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    public void testFunctionalError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
        OnExceptionRouteWithDefaultErrorHandlerTest.assertEquals((String)"<order><type>myType</type><user>Func</user></order>", (String)this.myOwnHandlerBean.getPayload());
    }

    public void testTechnicalError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Tech</user></order>");
        this.assertMockEndpointsSatisfied();
        OnExceptionRouteWithDefaultErrorHandlerTest.assertNull((Object)this.myOwnHandlerBean.getPayload());
    }

    public void testErrorWhileHandlingException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>FuncError</user></order>");
            OnExceptionRouteWithDefaultErrorHandlerTest.fail((String)"Should throw a RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            OnExceptionRouteWithDefaultErrorHandlerTest.assertEquals((String)"Damn something did not work", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        OnExceptionRouteWithDefaultErrorHandlerTest.assertNull((Object)this.myOwnHandlerBean.getPayload());
    }

    @Override
    protected void setUp() throws Exception {
        this.myOwnHandlerBean = new MyOwnHandlerBean();
        this.myServiceBean = new MyServiceBean();
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myOwnHandler", (Object)this.myOwnHandlerBean);
        jndi.bind("myServiceBean", (Object)this.myServiceBean);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(5));
                this.onException(MyTechnicalException.class).maximumRedeliveries(0).handled(true);
                this.onException(MyFunctionalException.class).maximumRedeliveries(0).handled(true).to("bean:myOwnHandler");
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().xpath("//type = 'myType'")).to("bean:myServiceBean")).end().to("mock:result");
            }
        };
    }
}

