/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;

public class OnExceptionOccurredProcessorOnExceptionTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myProcessor", (Object)new MyProcessor());
        return jndi;
    }

    public void testOnExceptionOccurred() throws Exception {
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyProcessor myProcessor = (MyProcessor)this.context.getRegistry().lookupByNameAndType("myProcessor", MyProcessor.class);
        OnExceptionOccurredProcessorOnExceptionTest.assertEquals((int)4, (int)myProcessor.getInvoked());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyProcessor myProcessor = (MyProcessor)OnExceptionOccurredProcessorOnExceptionTest.this.context.getRegistry().lookupByNameAndType("myProcessor", MyProcessor.class);
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                this.onException(Exception.class).maximumRedeliveries(3).redeliveryDelay(0L).onExceptionOccurred((Processor)myProcessor);
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        private int invoked;

        public void process(Exchange exchange) throws Exception {
            ++this.invoked;
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

