/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;

public class OnExceptionHandleAndThrowNewExceptionTest
extends ContextTestSupport {
    public void testOnExceptionHandleAndThrowNewException() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            OnExceptionHandleAndThrowNewExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IOException cause = OnExceptionHandleAndThrowNewExceptionTest.assertIsInstanceOf(IOException.class, e.getCause());
            OnExceptionHandleAndThrowNewExceptionTest.assertNotNull((Object)cause);
            OnExceptionHandleAndThrowNewExceptionTest.assertEquals((String)"First failure message is: Damn", (String)cause.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(true).to("log:onException")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                        TestCase.assertNotNull((Object)cause);
                        throw new IOException("First failure message is: " + cause.getMessage());
                    }
                });
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

