/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceHandlerTestHandler;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.TraceInterceptorFactory;
import org.apache.camel.processor.interceptor.TraceTestProcessor;
import org.apache.camel.processor.interceptor.Tracer;

public class TraceInterceptorSubclassFactory
implements TraceInterceptorFactory {
    private List<StringBuilder> eventMessages;
    private boolean traceAllNodes;

    public TraceInterceptorSubclassFactory(List<StringBuilder> eventMessages) {
        this.eventMessages = eventMessages;
    }

    public TraceInterceptor createTraceInterceptor(ProcessorDefinition<?> node, Processor target, TraceFormatter formatter, Tracer tracer) {
        return new TracerInterceptorSubclass(node, target, formatter, tracer, this.eventMessages, this);
    }

    public boolean getTraceAllNodes() {
        return this.traceAllNodes;
    }

    public void setTraceAllNodes(boolean traceAllNodes) {
        this.traceAllNodes = traceAllNodes;
    }

    private static class TracerInterceptorSubclass
    extends TraceInterceptor {
        private List<StringBuilder> eventMessages;
        private boolean traceThisNode = true;
        private TraceInterceptorSubclassFactory factory;

        TracerInterceptorSubclass(ProcessorDefinition<?> node, Processor target, TraceFormatter formatter, Tracer tracer, List<StringBuilder> eventMessages, TraceInterceptorSubclassFactory factory) {
            super(node, target, formatter, tracer);
            this.eventMessages = eventMessages;
            this.factory = factory;
            while (target instanceof DelegateProcessor) {
                target = ((DelegateProcessor)target).getProcessor();
            }
            if (target.getClass().equals(TraceTestProcessor.class)) {
                this.traceThisNode = false;
            }
        }

        private synchronized void storeMessage(StringBuilder message) {
            this.eventMessages.add(message);
        }

        protected void traceExchange(Exchange exchange) throws Exception {
            if (this.traceThisNode || this.factory.getTraceAllNodes()) {
                StringBuilder message = new StringBuilder();
                TraceHandlerTestHandler.recordComplete(message, this.getNode(), exchange);
                this.storeMessage(message);
            }
        }

        protected Object traceExchangeIn(Exchange exchange) throws Exception {
            if (this.traceThisNode || this.factory.getTraceAllNodes()) {
                StringBuilder message = new StringBuilder();
                TraceHandlerTestHandler.recordIn(message, this.getNode(), exchange);
                return message;
            }
            return null;
        }

        protected void traceExchangeOut(Exchange exchange, Object traceState) throws Exception {
            if ((this.traceThisNode || this.factory.getTraceAllNodes()) && StringBuilder.class.equals(traceState.getClass())) {
                StringBuilder message = (StringBuilder)traceState;
                TraceHandlerTestHandler.recordOut(message, this.getNode(), exchange);
                this.storeMessage(message);
            }
        }
    }
}

