/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.BreakpointSupport;
import org.apache.camel.impl.ConditionSupport;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;

public class DebugSingleStepConditionTest
extends ContextTestSupport {
    private List<String> logs = new ArrayList<String>();
    private Breakpoint breakpoint;
    private Condition beerCondition;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugSingleStepConditionTest.this.logs.add("Single stepping at " + definition.getLabel() + " with body: " + body);
            }
        };
        this.beerCondition = new ConditionSupport(){

            public boolean matchProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition) {
                return "beer".equals(exchange.getFromRouteId());
            }
        };
    }

    public void testDebug() throws Exception {
        this.context.getDebugger().addSingleStepBreakpoint(this.breakpoint, new Condition[]{this.beerCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Carlsberg"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:beer", (Object)"Carlsberg");
        this.assertMockEndpointsSatisfied();
        DebugSingleStepConditionTest.assertEquals((int)2, (int)this.logs.size());
        DebugSingleStepConditionTest.assertEquals((String)"Single stepping at log:beer with body: Carlsberg", (String)this.logs.get(0));
        DebugSingleStepConditionTest.assertEquals((String)"Single stepping at mock:result with body: Carlsberg", (String)this.logs.get(1));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                DebugSingleStepConditionTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).to("log:bar")).to("mock:result");
                ((RouteDefinition)this.from("direct:beer").routeId("beer").to("log:beer")).to("mock:result");
            }
        };
    }
}

