/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithReplaceFromTest
extends ContextTestSupport {
    public void testReplaceFromUri() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.replaceFromWith("seda:foo");
            }
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testReplaceFromEndpoint() throws Exception {
        final Endpoint endpoint = this.context.getEndpoint("seda:foo");
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.replaceFromWith(endpoint);
            }
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testReplaceFromInvalidUri() throws Exception {
        try {
            ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.replaceFromWith("xxx:foo");
                }
            });
            AdviceWithReplaceFromTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            AdviceWithReplaceFromTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

