/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class InterceptSendToExceptionTest
extends ContextTestSupport {
    public void testInterceptSendToException() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            InterceptSendToExceptionTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = InterceptSendToExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            InterceptSendToExceptionTest.assertEquals((String)"Damn", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock:foo").throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        };
    }
}

