/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class PollEnrichFileDefaultAggregationStrategyTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        PollEnrichFileDefaultAggregationStrategyTest.deleteDirectory("target/enrich");
        PollEnrichFileDefaultAggregationStrategyTest.deleteDirectory("target/enrichdata");
        super.setUp();
    }

    @Test
    public void testPollEnrichDefaultAggregationStrategyBody() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Start"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Big file"});
        mock.expectedFileExists("target/enrich/.done/AAA.fin");
        mock.expectedFileExists("target/enrichdata/.done/AAA.dat");
        this.template.sendBodyAndHeader("file://target/enrich", (Object)"Start", "CamelFileName", (Object)"AAA.fin");
        this.log.info("Sleeping for 1 sec before writing enrichdata file");
        Thread.sleep(1000L);
        this.template.sendBodyAndHeader("file://target/enrichdata", (Object)"Big file", "CamelFileName", (Object)"AAA.dat");
        this.log.info("... write done");
        this.assertMockEndpointsSatisfied();
        PollEnrichFileDefaultAggregationStrategyTest.assertFileDoesNotExists("target/enrichdata/AAA.dat.camelLock");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file://target/enrich?move=.done").to("mock:start")).pollEnrich("file://target/enrichdata?readLock=markerFile&move=.done", 10000L)).to("mock:result");
            }
        };
    }

    private static void assertFileDoesNotExists(String filename) {
        File file = new File(filename);
        PollEnrichFileDefaultAggregationStrategyTest.assertFalse((String)("File " + filename + " should not exist, it should have been deleted after being processed"), (boolean)file.exists());
    }
}

