/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.junit.Test;

public class PollEnrichFileCustomAggregationStrategyTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        PollEnrichFileCustomAggregationStrategyTest.deleteDirectory("target/enrich");
        PollEnrichFileCustomAggregationStrategyTest.deleteDirectory("target/enrichdata");
        super.setUp();
    }

    @Test
    public void testPollEnrichCustomAggregationStrategyBody() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Start"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Big file"});
        mock.expectedFileExists("target/enrich/.done/AAA.fin");
        mock.expectedFileExists("target/enrichdata/.done/AAA.dat");
        this.template.sendBodyAndHeader("file://target/enrich", (Object)"Start", "CamelFileName", (Object)"AAA.fin");
        this.log.info("Sleeping for 1 sec before writing enrichdata file");
        Thread.sleep(1000L);
        this.template.sendBodyAndHeader("file://target/enrichdata", (Object)"Big file", "CamelFileName", (Object)"AAA.dat");
        this.log.info("... write done");
        this.assertMockEndpointsSatisfied();
        PollEnrichFileCustomAggregationStrategyTest.assertFileDoesNotExists("target/enrichdata/AAA.dat.camelLock");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file://target/enrich?move=.done").to("mock:start")).pollEnrich("file://target/enrichdata?readLock=markerFile&move=.done", 10000L, (AggregationStrategy)new ReplaceAggregationStrategy())).to("mock:result");
            }
        };
    }

    private static void assertFileDoesNotExists(String filename) {
        File file = new File(filename);
        PollEnrichFileCustomAggregationStrategyTest.assertFalse((String)("File " + filename + " should not exist, it should have been deleted after being processed"), (boolean)file.exists());
    }

    class ReplaceAggregationStrategy
    implements AggregationStrategy {
        ReplaceAggregationStrategy() {
        }

        public Exchange aggregate(Exchange original, Exchange resource) {
            Object resourceResponse = resource.getIn().getBody();
            if (original.getPattern().isOutCapable()) {
                original.getOut().setBody(resourceResponse);
                original.getProperties().putAll(resource.getProperties());
            } else {
                original.getIn().setBody(resourceResponse);
                original.getProperties().putAll(resource.getProperties());
            }
            return original;
        }
    }
}

