/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import junit.framework.TestCase;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.slf4j.MDC;

public class AsyncMDCTest
extends ContextTestSupport {
    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testThreeMessagesMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Camel", "Bye Camel", "Bye Camel"});
        this.log.info("#1 message");
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.log.info("#2 message");
        this.template.sendBody("direct:a", (Object)"Hello Camel");
        this.log.info("#3 message");
        this.template.sendBody("direct:a", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncMDCTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                AsyncMDCTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-a", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                        TestCase.assertEquals((String)exchange.getContext().getName(), (String)MDC.get((String)"camel.contextId"));
                        TestCase.assertEquals((Object)exchange.getIn().getHeader("breadcrumbId"), (Object)MDC.get((String)"camel.breadcrumbId"));
                    }
                })).to("log:before")).to("async:bye:camel")).to("log:after")).to("direct:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-b", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }
}

