/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointMulticastFineGrainedErrorHandlingTest
extends ContextTestSupport {
    public void testAsyncEndpointOK() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointMulticastFineGrainedErrorHandlingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).multicast().stopOnException().to(new String[]{"mock:foo", "async:bye:camel", "mock:bar"});
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAsyncEndpointERROR() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointMulticastFineGrainedErrorHandlingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.onException(Exception.class).maximumRedeliveries(2);
                ((MulticastDefinition)((MulticastDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).multicast().stopOnException().to(new String[]{"mock:foo", "async:bye:camel"})).throwException((Exception)new IllegalArgumentException("Damn"))).to("mock:bar");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            AsyncEndpointMulticastFineGrainedErrorHandlingTest.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

