/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.GroupedMessageAggregationStrategy;

public class AggregateGroupMessageTest
extends ContextTestSupport {
    public void testGrouped() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"100");
        this.template.sendBody("direct:start", (Object)"150");
        this.template.sendBody("direct:start", (Object)"130");
        this.template.sendBody("direct:start", (Object)"200");
        this.template.sendBody("direct:start", (Object)"190");
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(0);
        List grouped = (List)out.getIn().getBody(List.class);
        AggregateGroupMessageTest.assertEquals((int)5, (int)grouped.size());
        AggregateGroupMessageTest.assertEquals((String)"100", (String)((String)((Message)grouped.get(0)).getBody(String.class)));
        AggregateGroupMessageTest.assertEquals((String)"150", (String)((String)((Message)grouped.get(1)).getBody(String.class)));
        AggregateGroupMessageTest.assertEquals((String)"130", (String)((String)((Message)grouped.get(2)).getBody(String.class)));
        AggregateGroupMessageTest.assertEquals((String)"200", (String)((String)((Message)grouped.get(3)).getBody(String.class)));
        AggregateGroupMessageTest.assertEquals((String)"190", (String)((String)((Message)grouped.get(4)).getBody(String.class)));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.constant(true), (AggregationStrategy)new GroupedMessageAggregationStrategy()).completionTimeout(500L).to("mock:result");
            }
        };
    }
}

