/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class WireTapStreamCachingTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    public void testSendingAMessageUsingWiretapConvertsToReReadable() throws Exception {
        this.x.expectedBodiesReceived(new Object[]{"<input/>+output"});
        this.y.expectedBodiesReceived(new Object[]{"<input/>+output"});
        this.z.expectedBodiesReceived(new Object[]{"<input/>+output"});
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)new StreamSource(new StringReader("<input/>")));
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingAMessageUsingWiretapShouldNotDeleteStreamFileBeforeAllExcangesAreComplete() throws InterruptedException {
        this.x.expectedMessageCount(1);
        this.y.expectedMessageCount(1);
        this.z.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/camel/processor/twoCharacters.txt"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                String body = (String)in.getBody(String.class);
                in.setBody((Object)(body + "+output"));
            }
        };
        return new RouteBuilder(){

            public void configure() {
                WireTapStreamCachingTest.this.context.setStreamCaching(Boolean.valueOf(true));
                WireTapStreamCachingTest.this.context.getStreamCachingStrategy().setSpoolThreshold(1L);
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                this.from("direct:a").wireTap("direct:x").wireTap("direct:y").wireTap("direct:z");
                ((RouteDefinition)this.from("direct:x").process(processor)).to("mock:x");
                ((ExpressionNode)this.from("direct:y").delay(2000L).process(processor)).to("mock:y");
                ((RouteDefinition)this.from("direct:z").process(processor)).to("mock:z");
            }
        };
    }
}

