/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDynamicDefinition;

public class WireTapBeanTest
extends ContextTestSupport {
    protected MockEndpoint tap;
    protected MockEndpoint result;

    public void testSend() throws Exception {
        this.result.expectedBodiesReceived(new Object[]{"Bye World"});
        this.tap.expectedBodiesReceived(new Object[]{"World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tap = this.getMockEndpoint("mock:tap");
        this.result = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ToDynamicDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).wireTap("seda:tap").bean(MyBean.class)).to("mock:result");
                this.from("seda:tap").to("mock:tap");
            }
        };
    }

    public static class MyBean {
        public String transform(String body) {
            return "Bye " + body;
        }
    }
}

