/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.validation.PredicateValidationException;

public class ValidateRegExpTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start", Endpoint.class);
        this.resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
    }

    public void testSendMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(1);
        this.template.sendBody(this.startEndpoint, (Object)"01.01.2010");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNotMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        try {
            this.template.sendBody(this.startEndpoint, (Object)"1.1.2010");
            ValidateRegExpTest.fail((String)"CamelExecutionException expected");
        }
        catch (CamelExecutionException e) {
            PredicateValidationException cause = ValidateRegExpTest.assertIsInstanceOf(PredicateValidationException.class, e.getCause());
            ValidateRegExpTest.assertTrue((String)"Get a wrong exception message", (boolean)cause.getMessage().startsWith("Validation failed for Predicate"));
            ValidateRegExpTest.assertTrue((boolean)cause.getMessage().contains("^\\d{2}\\.\\d{2}\\.\\d{4}$"));
            String body = (String)cause.getExchange().getIn().getBody(String.class);
            ValidateRegExpTest.assertEquals((String)"1.1.2010", (String)body);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").validate(this.bodyAs(String.class).regex("^\\d{2}\\.\\d{2}\\.\\d{4}$")).to("mock:result");
            }
        };
    }
}

