/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TryDefinition;

public class TryProcessorHandledTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.sendBody("direct:start", "Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testIllegalStateException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Damn State");
        this.assertMockEndpointsSatisfied();
    }

    public void testIOException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:io").expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Damn IO");
            TryProcessorHandledTest.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            TryProcessorHandledTest.assertIsInstanceOf(IOException.class, e.getCause());
            TryProcessorHandledTest.assertEquals((String)"Damn IO", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().process((Processor)new ProcessorFail())).to("mock:result")).doCatch(IOException.class).handled(false).to("mock:io")).doCatch(Exception.class).to("mock:error")).end();
            }
        };
    }

    public static class ProcessorFail
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Damn IO".equals(body)) {
                throw new IOException("Damn IO");
            }
            if ("Damn State".equals(body)) {
                throw new IllegalStateException("Damn State");
            }
        }
    }
}

