/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class SplitterStreamCacheTest
extends ContextTestSupport {
    private static final String TEST_FILE = "org/apache/camel/converter/stream/test.xml";
    protected int numMessages = 200;

    public void testSendStreamSource() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(this.numMessages);
        for (int c = 0; c < this.numMessages; ++c) {
            this.template.sendBody("seda:parallel", (Object)new StreamSource(this.getTestFileStream()));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SplitterStreamCacheTest.this.context.getStreamCachingStrategy().setSpoolDirectory("target/tmp");
                SplitterStreamCacheTest.this.context.getStreamCachingStrategy().setSpoolThreshold(-1L);
                this.from("seda:parallel?concurrentConsumers=5").streamCaching().split((Expression)XPathBuilder.xpath((String)"//person/city")).to("mock:result");
            }
        };
    }

    protected InputStream getTestFileStream() {
        InputStream answer = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TEST_FILE);
        SplitterStreamCacheTest.assertNotNull((String)"Should have found the file: org/apache/camel/converter/stream/test.xml on the classpath", (Object)answer);
        return answer;
    }
}

