/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class SplitTwoSubUnitOfWorkTest
extends ContextTestSupport {
    private static int counter;

    public void testOK() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Tiger", "Camel"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Elephant", "Lion"});
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Tiger", "Camel", "Elephant", "Lion"});
        MyBody body = new MyBody("Tiger,Camel", "Elephant,Lion");
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    public void testError() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:dead").message(0).body()).isInstanceOf(MyBody.class);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Tiger", "Camel"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Elephant", "Donkey"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Tiger", "Camel", "Elephant"});
        MyBody body = new MyBody("Tiger,Camel", "Elephant,Donkey");
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        SplitTwoSubUnitOfWorkTest.assertEquals((int)4, (int)counter);
        MyBody dead = (MyBody)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getIn().getBody(MyBody.class);
        SplitTwoSubUnitOfWorkTest.assertSame((String)"Should be original message in DLC", (Object)body, (Object)dead);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").useOriginalMessage().maximumRedeliveries(3).redeliveryDelay(0L));
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:start").to("mock:a")).split((Expression)this.simple("${body.foo}")).shareUnitOfWork().to("mock:b")).to("direct:line")).end().split((Expression)this.simple("${body.bar}")).shareUnitOfWork().to("mock:c")).to("direct:line")).end().to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:line").to("log:line")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body.contains("Donkey")) {
                            counter++;
                            throw new IllegalArgumentException("Donkey not allowed");
                        }
                    }
                })).to("mock:line");
            }
        };
    }

    public static final class MyBody {
        private String foo;
        private String bar;

        private MyBody(String foo, String bar) {
            this.foo = foo;
            this.bar = bar;
        }

        public String getFoo() {
            return this.foo;
        }

        public String getBar() {
            return this.bar;
        }
    }
}

