/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class ShutdownCompleteCurrentTaskOnlyTest
extends ContextTestSupport {
    private static String url = "file:target/pending";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ShutdownCompleteCurrentTaskOnlyTest.deleteDirectory("target/pending");
        this.template.sendBodyAndHeader(url, (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(url, (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(url, (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(url, (Object)"D", "CamelFileName", (Object)"d.txt");
        this.template.sendBodyAndHeader(url, (Object)"E", "CamelFileName", (Object)"e.txt");
    }

    public void testShutdownCompleteCurrentTaskOnly() throws Exception {
        this.context.getShutdownStrategy().setTimeout(20L);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        ShutdownCompleteCurrentTaskOnlyTest.assertTrue((String)("Should NOT complete all messages, was: " + bar.getReceivedCounter()), (bar.getReceivedCounter() < 5 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(url).shutdownRunningTask(ShutdownRunningTask.CompleteCurrentTaskOnly).delay(1000L).to("seda:foo");
                this.from("seda:foo").routeId("route2").to("mock:bar");
            }
        };
    }
}

