/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;

public class RoutingSlipInOutAndInOnlyTest
extends ContextTestSupport {
    private String slip = "direct:a,direct:b,direct:c";

    public void testRoutingSlipInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"HelloABC"});
        String out = (String)this.template.requestBodyAndHeader("direct:start", (Object)"Hello", "slip", (Object)this.slip, String.class);
        RoutingSlipInOutAndInOnlyTest.assertEquals((String)"HelloABC", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testRoutingSlipInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"HelloABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "slip", (Object)this.slip);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routingSlip((Expression)this.header("slip")).to("mock:result");
                this.from("direct:a").transform((Expression)this.body().append((Object)"A"));
                this.from("direct:b").transform((Expression)this.body().append((Object)"B"));
                this.from("direct:c").transform((Expression)this.body().append((Object)"C"));
            }
        };
    }
}

