/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class RoutingSlipContextScopedOnExceptionIssueTest
extends ContextTestSupport {
    public void testUsingInterceptor() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String routeId = exchange.getUnitOfWork().getRouteContext().getRoute().getId();
                        TestCase.assertEquals((String)"fail", (String)routeId);
                    }
                })).to("mock:error");
                this.interceptSendToEndpoint("direct*").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String target = (String)exchange.getIn().getHeader("CamelInterceptedEndpoint", String.class);
                        exchange.getIn().setHeader("target", (Object)target);
                    }
                });
                this.from("direct:start").routeId("start").routingSlip((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").routeId("foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:fail").routeId("fail").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(0).header("target")).isEqualTo((Object)"direct://fail");
        String foo = "direct:foo,direct:fail";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", foo);
        headers.put("CamelFileName", "hello.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }

    public void testUsingExistingHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String routeId = exchange.getUnitOfWork().getRouteContext().getRoute().getId();
                        TestCase.assertEquals((String)"fail", (String)routeId);
                    }
                })).to("mock:error");
                this.from("direct:start").routeId("start").routingSlip((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").routeId("foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:fail").routeId("fail").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:foo").message(0).header("CamelToEndpoint")).isEqualTo((Object)"mock://foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(0).header("CamelFailureEndpoint")).isEqualTo((Object)"direct://fail");
        String foo = "direct:foo,direct:fail";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", foo);
        headers.put("CamelFileName", "hello.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }
}

