/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;

public class RouteAwareSynchronizationTest
extends ContextTestSupport {
    private static final List<String> EVENTS = new ArrayList<String>();

    public void testRouteAwareSynchronization() throws Exception {
        EVENTS.clear();
        RouteAwareSynchronizationTest.assertEquals((int)0, (int)EVENTS.size());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.addOnCompletion((Synchronization)new MyRouteAware());
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        this.assertMockEndpointsSatisfied();
        RouteAwareSynchronizationTest.assertEquals((int)5, (int)EVENTS.size());
        RouteAwareSynchronizationTest.assertEquals((String)"onBeforeRoute-start", (String)EVENTS.get(0));
        RouteAwareSynchronizationTest.assertEquals((String)"onBeforeRoute-foo", (String)EVENTS.get(1));
        RouteAwareSynchronizationTest.assertEquals((String)"onAfterRoute-foo", (String)EVENTS.get(2));
        RouteAwareSynchronizationTest.assertEquals((String)"onAfterRoute-start", (String)EVENTS.get(3));
        RouteAwareSynchronizationTest.assertEquals((String)"onComplete", (String)EVENTS.get(4));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("start").to("mock:a")).to("direct:foo")).to("mock:b");
                this.from("direct:foo").routeId("foo").to("mock:foo");
            }
        };
    }

    private static final class MyRouteAware
    implements SynchronizationRouteAware {
        private MyRouteAware() {
        }

        public void onBeforeRoute(Route route, Exchange exchange) {
            EVENTS.add("onBeforeRoute-" + route.getId());
        }

        public void onAfterRoute(Route route, Exchange exchange) {
            EVENTS.add("onAfterRoute-" + route.getId());
        }

        public void onComplete(Exchange exchange) {
            EVENTS.add("onComplete");
        }

        public void onFailure(Exchange exchange) {
            EVENTS.add("onFailure");
        }
    }
}

