/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RecipientListWithArrayHeaderTest
extends ContextTestSupport {
    public void testSendingAMessageUsingMulticastReceivesItsOwnExchange() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody() {
        this.template.sendBodyAndHeader("direct:a", (Object)"answer", "recipientListHeader", (Object)new String[]{"mock:x", "mock:y", "mock:z"});
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("recipientListHeader"));
            }
        };
    }
}

