/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class RecipientListParallelTimeoutTest
extends ContextTestSupport {
    public void testRecipientListParallelTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((ValueBuilder)mock.message(0).body()).not(RecipientListParallelTimeoutTest.body().contains((Object)"A"));
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "slip", (Object)"direct:a,direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.header("slip")).aggregationStrategy(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().timeout(1000L).to("mock:result");
                this.from("direct:a").delay(5000L).setBody((Expression)this.constant("A"));
                this.from("direct:b").setBody((Expression)this.constant("B"));
                this.from("direct:c").delay(500L).setBody((Expression)this.constant("C"));
            }
        };
    }
}

