/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.processor.RandomLoadBalanceTest;
import org.apache.camel.processor.interceptor.DefaultChannel;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RandomLoadBalancer;

public class RandomLoadBalanceJavaDSLBuilderTest
extends RandomLoadBalanceTest {
    public void testNavigateRouteAsJavaDSLWithNavigate() throws Exception {
        StringBuilder sb = new StringBuilder();
        Route route = (Route)this.context.getRoutes().get(0);
        sb.append("from(\"" + route.getEndpoint().getEndpointUri() + "\")");
        Navigate nav = route.navigate();
        this.navigateRoute((Navigate<Processor>)nav, sb);
        RandomLoadBalanceJavaDSLBuilderTest.assertEquals((String)"from(\"direct://start\").loadBalance().random().to(\"mock://x\").to(\"mock://y\").to(\"mock://z\")", (String)sb.toString());
    }

    public void testNavigateRouteAsJavaDSL() throws Exception {
        StringBuilder sb = new StringBuilder();
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        sb.append("from(\"" + ((FromDefinition)route.getInputs().get(0)).getUri() + "\")");
        this.navigateDefinition((ProcessorDefinition<?>)route, sb);
        RandomLoadBalanceJavaDSLBuilderTest.assertEquals((String)"from(\"direct://start\").loadBalance().random().to(\"mock://x\").to(\"mock://y\").to(\"mock://z\")", (String)sb.toString());
    }

    private void navigateRoute(Navigate<Processor> nav, StringBuilder sb) {
        if (!nav.hasNext()) {
            return;
        }
        if (nav instanceof DefaultChannel) {
            DefaultChannel channel = (DefaultChannel)nav;
            ProcessorDefinition def = channel.getProcessorDefinition();
            this.navigateDefinition(def, sb);
        }
    }

    private void navigateDefinition(ProcessorDefinition<?> def, StringBuilder sb) {
        List children;
        ProcessorDefinition<?> defn = def;
        if (defn instanceof LoadBalanceDefinition) {
            sb.append(".loadBalance()");
            LoadBalanceDefinition lbd = (LoadBalanceDefinition)defn;
            LoadBalancer balancer = lbd.getLoadBalancerType().getLoadBalancer(null);
            if (balancer instanceof RandomLoadBalancer) {
                sb.append(".random()");
            }
        }
        if (defn instanceof SendDefinition) {
            SendDefinition send = (SendDefinition)defn;
            sb.append(".to(\"" + send.getUri() + "\")");
        }
        if ((children = defn.getOutputs()) == null || children.isEmpty()) {
            return;
        }
        for (ProcessorDefinition child : children) {
            this.navigateDefinition(child, sb);
        }
    }
}

