/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;

public class MulticastNoStopOnExceptionTest
extends ContextTestSupport {
    public void testMulticastNoStopOnExceptionOk() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:baz").expectedBodiesReceived(new Object[]{"Hello"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testMulticastNoStopOnExceptionStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            MulticastNoStopOnExceptionTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            MulticastNoStopOnExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            MulticastNoStopOnExceptionTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast().to(new String[]{"direct:foo", "direct:bar", "direct:baz"})).end().to("mock:result");
                this.from("direct:foo").to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").process((Processor)new MyProcessor())).to("mock:bar");
                this.from("direct:baz").to("mock:baz");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kaboom".equals(body)) {
                throw new IllegalArgumentException("Forced");
            }
        }
    }
}

