/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCOnCompletionOnCompletionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MDCOnCompletionOnCompletionTest.class);

    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MDCOnCompletionOnCompletionTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                ((OnCompletionDefinition)((ProcessorDefinition)this.from("timer:foo?period=5000").routeId("route-a").setBody().constant((Object)"Hello World")).onCompletion().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.addOnCompletion((Synchronization)new MyOnCompletion());
                    }
                })).end().to("log:foo").to("direct:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").routeId("route-b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((String)"route-b", (String)MDC.get((String)"camel.routeId"));
                        TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
                        TestCase.assertEquals((String)exchange.getIn().getMessageId(), (String)MDC.get((String)"camel.messageId"));
                        MDC.put((String)"custom.id", (String)"1");
                        LOG.info("From processor in route-b");
                    }
                })).to("log:bar")).to("mock:result");
            }
        };
    }

    private class MyOnCompletion
    extends SynchronizationAdapter {
        private MyOnCompletion() {
        }

        public void onDone(Exchange exchange) {
            TestCase.assertEquals((String)"route-a", (String)MDC.get((String)"camel.routeId"));
            TestCase.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"camel.exchangeId"));
            TestCase.assertEquals((String)exchange.getIn().getMessageId(), (String)MDC.get((String)"camel.messageId"));
            TestCase.assertEquals((String)"1", (String)MDC.get((String)"custom.id"));
            LOG.info("From onCompletion after route-a");
        }
    }
}

