/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.TestCase;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Assert;
import org.slf4j.MDC;

public class MDCAsyncTest
extends ContextTestSupport {
    public void testMdcPreservedAfterAsyncEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MDCAsyncTest.this.context.setUseMDCLogging(Boolean.valueOf(true));
                MdcCheckerProcessor checker = new MdcCheckerProcessor();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("route-async").process((Processor)checker)).to("log:foo")).process((Processor)new MyAsyncProcessor())).process((Processor)checker)).to("mock:end");
            }
        };
    }

    private static class MdcCheckerProcessor
    implements Processor {
        private String routeId = "route-async";
        private String exchangeId;
        private String messageId;
        private String breadcrumbId;
        private String contextId;
        private Long threadId;

        private MdcCheckerProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            if (this.threadId != null) {
                Assert.assertNotEquals((Object)this.threadId, (Object)Thread.currentThread().getId());
            } else {
                this.threadId = Thread.currentThread().getId();
            }
            if (this.routeId != null) {
                TestCase.assertEquals((String)this.routeId, (String)MDC.get((String)"camel.routeId"));
            }
            if (this.exchangeId != null) {
                TestCase.assertEquals((String)this.exchangeId, (String)MDC.get((String)"camel.exchangeId"));
            } else {
                this.exchangeId = MDC.get((String)"camel.exchangeId");
                TestCase.assertTrue((this.exchangeId != null && this.exchangeId.length() > 0 ? 1 : 0) != 0);
            }
            if (this.messageId != null) {
                TestCase.assertEquals((String)this.messageId, (String)MDC.get((String)"camel.messageId"));
            } else {
                this.messageId = MDC.get((String)"camel.messageId");
                TestCase.assertTrue((this.messageId != null && this.messageId.length() > 0 ? 1 : 0) != 0);
            }
            if (this.breadcrumbId != null) {
                TestCase.assertEquals((String)this.breadcrumbId, (String)MDC.get((String)"camel.breadcrumbId"));
            } else {
                this.breadcrumbId = MDC.get((String)"camel.breadcrumbId");
                TestCase.assertTrue((this.breadcrumbId != null && this.breadcrumbId.length() > 0 ? 1 : 0) != 0);
            }
            if (this.contextId != null) {
                TestCase.assertEquals((String)this.contextId, (String)MDC.get((String)"camel.contextId"));
            } else {
                this.contextId = MDC.get((String)"camel.contextId");
                TestCase.assertTrue((this.contextId != null && this.contextId.length() > 0 ? 1 : 0) != 0);
            }
        }
    }

    private static class MyAsyncProcessor
    implements AsyncProcessor {
        private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(1);

        MyAsyncProcessor() {
            EXECUTOR.submit(new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public void process(Exchange exchange) throws Exception {
            throw new RuntimeCamelException("This processor does not support the sync pattern.");
        }

        public boolean process(Exchange exchange, final AsyncCallback callback) {
            EXECUTOR.submit(new Runnable(){

                @Override
                public void run() {
                    callback.done(false);
                }
            });
            return false;
        }
    }
}

