/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;

public class IdempotentConsumerRepoExceptionTest
extends ContextTestSupport {
    private IdempotentRepository myRepo = new MyRepo();

    public void testRepoException() throws Exception {
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"nineninenine"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"two", "messageId", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"nineninenine", "messageId", (Object)"999");
        this.template.sendBodyAndHeader("direct:start", (Object)"two", "messageId", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"three", "messageId", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), IdempotentConsumerRepoExceptionTest.this.myRepo).to("mock:result");
            }
        };
    }

    private class MyRepo
    extends MemoryIdempotentRepository {
        private MyRepo() {
        }

        public boolean add(String key) {
            if ("999".equals(key)) {
                throw new IllegalArgumentException("Forced");
            }
            return super.add(key);
        }
    }
}

