/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class HandleFaultPerRouteTest
extends ContextTestSupport {
    public void testHandleFaultPerRoute() throws Exception {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedMessageCount(1);
        MockEndpoint c = this.getMockEndpoint("mock:c");
        c.expectedMessageCount(1);
        Exchange outA = this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getOut().setFault(true);
                exchange.getOut().setBody((Object)new IllegalArgumentException("A"));
            }
        });
        HandleFaultPerRouteTest.assertTrue((String)"Should be failed", (boolean)outA.isFailed());
        HandleFaultPerRouteTest.assertIsInstanceOf(IllegalArgumentException.class, outA.getException());
        HandleFaultPerRouteTest.assertEquals((String)"A", (String)outA.getException().getMessage());
        Exchange outB = this.template.send("direct:b", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getOut().setFault(true);
                exchange.getOut().setBody((Object)new IllegalArgumentException("B"));
            }
        });
        HandleFaultPerRouteTest.assertTrue((String)"Should be failed", (boolean)outB.isFailed());
        HandleFaultPerRouteTest.assertNull((String)"Should not handle fault", (Object)outB.getException());
        HandleFaultPerRouteTest.assertTrue((outB.getOut() != null && outB.getOut().isFault() ? 1 : 0) != 0);
        HandleFaultPerRouteTest.assertIsInstanceOf(IllegalArgumentException.class, outB.getOut().getBody());
        Exchange outC = this.template.send("direct:c", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getOut().setFault(true);
                exchange.getOut().setBody((Object)new IllegalArgumentException("C"));
            }
        });
        HandleFaultPerRouteTest.assertTrue((String)"Should be failed", (boolean)outC.isFailed());
        HandleFaultPerRouteTest.assertIsInstanceOf(IllegalArgumentException.class, outC.getException());
        HandleFaultPerRouteTest.assertEquals((String)"C", (String)outC.getException().getMessage());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                HandleFaultPerRouteTest.this.context.setHandleFault(Boolean.valueOf(true));
                this.from("direct:a").to("mock:a");
                this.from("direct:b").noHandleFault().to("mock:b");
                this.from("direct:c").handleFault().to("mock:c");
            }
        };
    }
}

