/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ChoiceDefinition;

public class DetourTest
extends ContextTestSupport {
    private static final String BODY = "<order custId=\"123\"/>";
    private ControlBean controlBean;

    public void testDetourSet() throws Exception {
        this.controlBean.setDetour(true);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        ((ValueBuilder)resultEndpoint.message(0).body()).isEqualTo((Object)BODY);
        MockEndpoint detourEndpoint = this.getMockEndpoint("mock:detour");
        detourEndpoint.expectedMessageCount(1);
        ((ValueBuilder)detourEndpoint.message(0).body()).isEqualTo((Object)BODY);
        this.template.sendBody("direct:start", (Object)BODY);
        this.assertMockEndpointsSatisfied();
    }

    public void testDetourNotSet() throws Exception {
        this.controlBean.setDetour(false);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        ((ValueBuilder)resultEndpoint.message(0).body()).isEqualTo((Object)BODY);
        MockEndpoint detourEndpoint = this.getMockEndpoint("mock:detour");
        detourEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)BODY);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        this.controlBean = new ControlBean();
        jndi.bind("controlBean", (Object)this.controlBean);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().method("controlBean", "isDetour")).to("mock:detour")).end().to("mock:result");
            }
        };
    }

    public final class ControlBean {
        private boolean detour;

        public void setDetour(boolean detour) {
            this.detour = detour;
        }

        public boolean isDetour() {
            return this.detour;
        }
    }
}

