/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.ObjectHelper;

public class DataFormatTest
extends ContextTestSupport {
    public void testMarshalThenUnmarshalBean() throws Exception {
        MyBean bean = new MyBean();
        bean.name = "James";
        bean.counter = 5;
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{bean});
        this.template.sendBody("direct:start", (Object)bean);
        resultEndpoint.assertIsSatisfied();
    }

    public void testMarshalNonSerializableBean() throws Exception {
        MyNonSerializableBean bean = new MyNonSerializableBean("James");
        try {
            this.template.sendBody("direct:start", (Object)bean);
            DataFormatTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            DataFormatTest.assertIsInstanceOf(NotSerializableException.class, e.getCause());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().serialization().to("direct:marshalled");
                this.from("direct:marshalled").unmarshal().serialization().to("mock:result");
            }
        };
    }

    protected static class MyNonSerializableBean {
        private String name;

        public MyNonSerializableBean(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    protected static class MyBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public int counter;

        protected MyBean() {
        }

        public boolean equals(Object o) {
            if (o instanceof MyBean) {
                MyBean that = (MyBean)o;
                return ObjectHelper.equal((Object)this.name, (Object)that.name) && ObjectHelper.equal((Object)this.counter, (Object)that.counter);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.counter;
        }
    }
}

