/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;

public class CustomProcessorFactoryTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setProcessorFactory((ProcessorFactory)new MyFactory());
        return context;
    }

    public void testAlterDefinitionUsingProcessorFactory() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"body was altered"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAlterDefinitionUsingProcessorFactoryWithChild() throws Exception {
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"body was altered", "body was altered"});
        this.getMockEndpoint("mock:extra").expectedBodiesReceived(new Object[]{"body was altered", "body was altered"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello,World"});
        this.template.sendBody("direct:foo", (Object)"Hello,World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)this.from("direct:start").setBody().constant((Object)"body not altered")).to("mock:foo");
                ((ExpressionNode)((ProcessorDefinition)this.from("direct:foo").split((Expression)this.body()).setBody().constant((Object)"body not altered")).to("mock:split")).end().to("mock:result");
            }
        };
    }

    public static class MyFactory
    implements ProcessorFactory {
        public Processor createChildProcessor(RouteContext routeContext, ProcessorDefinition<?> definition, boolean mandatory) throws Exception {
            return null;
        }

        public Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> definition) throws Exception {
            if (definition instanceof SplitDefinition) {
                SplitDefinition split = (SplitDefinition)definition;
                split.addOutput((ProcessorDefinition)new ToDefinition("mock:extra"));
            }
            if (definition instanceof SetBodyDefinition) {
                SetBodyDefinition set = (SetBodyDefinition)definition;
                set.setExpression((ExpressionDefinition)new ConstantExpression("body was altered"));
            }
            return null;
        }
    }
}

