/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.Locale;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ConvertBodyTest
extends ContextTestSupport {
    public void testConvertBodyTo() {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((RouteDefinition)this.from("direct:invalid").convertBodyTo(String.class, "ASSI")).to("mock:endpoint");
                }
            });
            ConvertBodyTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            ConvertBodyTest.assertIsInstanceOf(UnsupportedCharsetException.class, e.getCause());
        }
    }

    public void testConvertBodyCharset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").convertBodyTo(byte[].class, "iso-8859-1")).to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelCharsetName")).isNull();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testConvertToInteger() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{11});
        this.template.sendBody("direct:start", (Object)"11");
        this.assertMockEndpointsSatisfied();
    }

    public void testConvertNullBody() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        ((ValueBuilder)result.message(0).body()).isNull();
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    public void testConvertFailed() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:invalid", (Object)"11");
            ConvertBodyTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeCamelException e) {
            ConvertBodyTest.assertTrue((boolean)(e.getCause() instanceof InvalidPayloadException));
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testConvertToBytesCharset() throws Exception {
        byte[] body = "Hello World".getBytes("iso-8859-1");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testConvertToStringCharset() throws Exception {
        String body = "Hello World";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset3", (Object)new ByteArrayInputStream(body.getBytes("utf-16")));
        this.assertMockEndpointsSatisfied();
    }

    public void testConvertToBytesCharsetFail() throws Exception {
        byte[] body = "Hello World".getBytes("utf-8");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset2", (Object)"Hello World");
        result.assertIsNotSatisfied();
    }

    public void testConvertToStringCharsetFail() throws Exception {
        boolean aix;
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        boolean bl = aix = osName.indexOf("aix") > -1;
        if (aix) {
            return;
        }
        String body = "Hell\u00f6 W\u00f6rld";
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:charset3", (Object)new ByteArrayInputStream(body.getBytes("utf-8")));
        result.assertIsNotSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").convertBodyTo(Integer.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:invalid").convertBodyTo(Date.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:charset").convertBodyTo(byte[].class, "iso-8859-1")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset2").convertBodyTo(byte[].class, "utf-16")).to("mock:result");
                ((RouteDefinition)this.from("direct:charset3").convertBodyTo(String.class, "utf-16")).to("mock:result");
            }
        };
    }
}

