/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultModelJAXBContextFactory;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.rest.RestContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlTestSupport
extends TestSupport {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected JAXBContext jaxbContext;

    protected RouteContainer assertParseAsJaxb(String uri) throws JAXBException {
        Object value = this.parseUri(uri);
        RouteContainer context = XmlTestSupport.assertIsInstanceOf(RouteContainer.class, value);
        this.log.info("Found: " + context);
        return context;
    }

    protected RestContainer assertParseRestAsJaxb(String uri) throws JAXBException {
        Object value = this.parseUri(uri);
        RestContainer context = XmlTestSupport.assertIsInstanceOf(RestContainer.class, value);
        this.log.info("Found: " + context);
        return context;
    }

    protected Object parseUri(String uri) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        URL resource = ((Object)((Object)this)).getClass().getResource(uri);
        XmlTestSupport.assertNotNull((String)("Cannot find resource on the classpath: " + uri), (Object)resource);
        Object value = unmarshaller.unmarshal(resource);
        return value;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jaxbContext = XmlTestSupport.createJaxbContext();
    }

    public static JAXBContext createJaxbContext() throws JAXBException {
        return new DefaultModelJAXBContextFactory().newJAXBContext();
    }
}

